/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.to;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="_class")
@JsonPropertyOrder(value={"_class", "key", "type", "realm", "username", "name"})
@Schema(subTypes={UserTO.class, GroupTO.class, AnyObjectTO.class}, discriminatorProperty="_class")
public abstract class AnyTO
implements EntityTO,
RealmMember {
    private static final long serialVersionUID = -754311920679872084L;
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    private String discriminator;
    private String creator;
    private OffsetDateTime creationDate;
    private String creationContext;
    private String lastModifier;
    private OffsetDateTime lastChangeDate;
    private String lastChangeContext;
    private String key;
    private String type;
    private String realm;
    private final List<String> dynRealms = new ArrayList<String>();
    private String status;
    private final Set<String> auxClasses = new TreeSet<String>();
    private final Set<Attr> plainAttrs = new TreeSet<Attr>();
    private final Set<Attr> derAttrs = new TreeSet<Attr>();
    private final Set<Attr> virAttrs = new TreeSet<Attr>();
    private final Set<String> resources = new TreeSet<String>();

    @Schema(name="_class", required=true)
    public abstract String getDiscriminator();

    public void setDiscriminator(String discriminator) {
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationContext() {
        return this.creationContext;
    }

    public void setCreationContext(String creationContext) {
        this.creationContext = creationContext;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public OffsetDateTime getLastChangeDate() {
        return this.lastChangeDate;
    }

    public void setLastChangeDate(OffsetDateTime lastChangeDate) {
        this.lastChangeDate = lastChangeDate;
    }

    public String getLastChangeContext() {
        return this.lastChangeContext;
    }

    public void setLastChangeContext(String lastChangeContext) {
        this.lastChangeContext = lastChangeContext;
    }

    @JsonIgnore
    public String getETagValue() {
        OffsetDateTime etagDate = this.getLastChangeDate() == null ? this.getCreationDate() : this.getLastChangeDate();
        return Optional.ofNullable(etagDate).map(date -> String.valueOf(date.toInstant().toEpochMilli())).orElse("");
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public void setRealm(String realm) {
        this.realm = realm;
    }

    @JacksonXmlElementWrapper(localName="dynRealms")
    @JacksonXmlProperty(localName="dynRealmF")
    public List<String> getDynRealms() {
        return this.dynRealms;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    @JacksonXmlElementWrapper(localName="auxClasses")
    @JacksonXmlProperty(localName="class")
    public Set<String> getAuxClasses() {
        return this.auxClasses;
    }

    @Override
    @JacksonXmlElementWrapper(localName="plainAttrs")
    @JacksonXmlProperty(localName="plainAttr")
    public Set<Attr> getPlainAttrs() {
        return this.plainAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getPlainAttr(String schema) {
        return this.plainAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="derAttrs")
    @JacksonXmlProperty(localName="derAttr")
    public Set<Attr> getDerAttrs() {
        return this.derAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getDerAttr(String schema) {
        return this.derAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="virAttrs")
    @JacksonXmlProperty(localName="virAttr")
    public Set<Attr> getVirAttrs() {
        return this.virAttrs;
    }

    @Override
    @JsonIgnore
    public Optional<Attr> getVirAttr(String schema) {
        return this.virAttrs.stream().filter(attr -> attr.getSchema().equals(schema)).findFirst();
    }

    @Override
    public Set<String> getResources() {
        return this.resources;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.creator).append((Object)this.creationDate).append((Object)this.creationContext).append((Object)this.lastModifier).append((Object)this.lastChangeDate).append((Object)this.lastChangeContext).append((Object)this.key).append((Object)this.type).append((Object)this.realm).append(this.dynRealms).append((Object)this.status).append(this.auxClasses).append(this.plainAttrs).append(this.derAttrs).append(this.virAttrs).append(this.resources).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyTO other = (AnyTO)obj;
        return new EqualsBuilder().append((Object)this.creator, (Object)other.creator).append((Object)this.creationDate, (Object)other.creationDate).append((Object)this.creationContext, (Object)other.creationContext).append((Object)this.lastModifier, (Object)other.lastModifier).append((Object)this.lastChangeDate, (Object)other.lastChangeDate).append((Object)this.lastChangeContext, (Object)other.lastChangeContext).append((Object)this.key, (Object)other.key).append((Object)this.type, (Object)other.type).append((Object)this.realm, (Object)other.realm).append(this.dynRealms, other.dynRealms).append((Object)this.status, (Object)other.status).append(this.auxClasses, other.auxClasses).append(this.plainAttrs, other.plainAttrs).append(this.derAttrs, other.derAttrs).append(this.virAttrs, other.virAttrs).append(this.resources, other.resources).build();
    }
}

