/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.multipdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

class PDFCloneUtility {
    private final PDDocument destination;
    private final Map<Object, COSBase> clonedVersion = new HashMap<Object, COSBase>();
    private final Set<COSBase> clonedValues = new HashSet<COSBase>();

    PDFCloneUtility(PDDocument dest) {
        this.destination = dest;
    }

    PDDocument getDestination() {
        return this.destination;
    }

    COSBase cloneForNewDocument(Object base) throws IOException {
        if (base == null) {
            return null;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return retval;
        }
        if (base instanceof COSBase && this.clonedValues.contains(base)) {
            return (COSBase)base;
        }
        if (base instanceof List) {
            COSArray array = new COSArray();
            List list = (List)base;
            for (Object e : list) {
                array.add(this.cloneForNewDocument(e));
            }
            retval = array;
        } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            retval = this.cloneForNewDocument(((COSObjectable)base).getCOSObject());
        } else if (base instanceof COSObject) {
            COSObject object = (COSObject)base;
            retval = this.cloneForNewDocument(object.getObject());
        } else if (base instanceof COSArray) {
            COSArray newArray = new COSArray();
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                COSBase cOSBase = array.get(i);
                this.checkForRecursion(base, cOSBase);
                newArray.add(this.cloneForNewDocument(cOSBase));
            }
            retval = newArray;
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            COSStream stream = this.destination.getDocument().createCOSStream();
            Throwable throwable = null;
            try (OutputStream output = stream.createRawOutputStream();
                 InputStream input2 = originalStream.createRawInputStream();){
                IOUtils.copy(input2, output);
            }
            catch (Throwable input2) {
                Throwable throwable2 = input2;
                throw input2;
            }
            this.clonedVersion.put(base, stream);
            for (Map.Entry entry : originalStream.entrySet()) {
                COSBase value = (COSBase)entry.getValue();
                this.checkForRecursion(base, value);
                stream.setItem((COSName)entry.getKey(), this.cloneForNewDocument(value));
            }
            retval = stream;
        } else if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            retval = new COSDictionary();
            this.clonedVersion.put(base, retval);
            for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                COSBase cOSBase = entry.getValue();
                this.checkForRecursion(base, cOSBase);
                ((COSDictionary)retval).setItem(entry.getKey(), this.cloneForNewDocument(cOSBase));
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
        this.clonedValues.add(retval);
        return retval;
    }

    void cloneMerge(COSObjectable base, COSObjectable target) throws IOException {
        if (base == null || base == target) {
            return;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return;
        }
        if (!(base instanceof COSBase)) {
            this.cloneMerge(base.getCOSObject(), target.getCOSObject());
        } else if (base instanceof COSObject) {
            if (target instanceof COSObject) {
                this.cloneMerge(((COSObject)base).getObject(), ((COSObject)target).getObject());
            } else if (target instanceof COSDictionary || target instanceof COSArray) {
                this.cloneMerge(((COSObject)base).getObject(), target);
            }
        } else if (base instanceof COSArray) {
            if (target instanceof COSObject) {
                this.cloneMerge(base, ((COSObject)target).getObject());
            } else {
                COSArray array = (COSArray)base;
                for (int i = 0; i < array.size(); ++i) {
                    ((COSArray)target).add(this.cloneForNewDocument(array.get(i)));
                }
            }
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            COSStream stream = this.destination.getDocument().createCOSStream();
            Throwable throwable = null;
            try (OutputStream output = stream.createOutputStream(originalStream.getFilters());){
                IOUtils.copy(originalStream.createInputStream(), output);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            this.clonedVersion.put(base, stream);
            for (Map.Entry entry : originalStream.entrySet()) {
                stream.setItem((COSName)entry.getKey(), this.cloneForNewDocument(entry.getValue()));
            }
            retval = stream;
        } else if (base instanceof COSDictionary) {
            if (target instanceof COSObject) {
                this.cloneMerge(base, ((COSObject)target).getObject());
            } else {
                COSDictionary dic = (COSDictionary)base;
                this.clonedVersion.put(base, retval);
                for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                    COSName cOSName = entry.getKey();
                    COSBase value = entry.getValue();
                    if (((COSDictionary)target).getItem(cOSName) != null) {
                        this.cloneMerge(value, ((COSDictionary)target).getItem(cOSName));
                        continue;
                    }
                    ((COSDictionary)target).setItem(cOSName, this.cloneForNewDocument(value));
                }
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
        this.clonedValues.add(retval);
    }

    private void checkForRecursion(Object parent, COSBase value) throws IOException {
        COSBase actual;
        if (value instanceof COSObject && (actual = ((COSObject)value).getObject()) == parent) {
            throw new IOException("Loop within object " + value);
        }
    }
}

