/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.commons.ProvisioningUtils;
import org.apache.syncope.client.enduser.layout.UserFormLayoutInfo;
import org.apache.syncope.client.enduser.pages.BasePage;
import org.apache.syncope.client.enduser.pages.SelfResult;
import org.apache.syncope.client.enduser.panels.UserFormPanel;
import org.apache.syncope.client.enduser.panels.any.Details;
import org.apache.syncope.client.enduser.panels.any.SelfUserDetails;
import org.apache.syncope.client.enduser.rest.UserSelfRestClient;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.SecurityQuestionTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.rest.api.service.SecurityQuestionService;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.component.IRequestablePage;

public class UserSelfFormPanel
extends UserFormPanel {
    private static final long serialVersionUID = 6763365006334514387L;
    private final UserSelfRestClient userSelfRestClient = new UserSelfRestClient();
    private TextField<String> securityQuestion;
    private String usernameText;

    public UserSelfFormPanel(String id, UserTO previousUserTO, UserTO userTO, List<String> anyTypeClasses, UserFormLayoutInfo formLayoutInfo, PageReference pageReference) {
        super(id, previousUserTO, userTO, anyTypeClasses, formLayoutInfo, pageReference);
    }

    @Override
    protected Details<UserTO> addOptionalDetailsPanel(UserWrapper modelObject) {
        return new SelfUserDetails("contentPanel", (UserWrapper)UserWrapper.class.cast(modelObject), ((UserFormLayoutInfo)((Object)UserFormLayoutInfo.class.cast((Object)this.formLayoutInfo))).isPasswordManagement(), this.pageRef);
    }

    @Override
    protected void onFormSubmit(AjaxRequestTarget target) {
        if (SyncopeWebApplication.get().isCaptchaEnabled() && !this.captcha.check()) {
            SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("captcha_error")));
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        } else {
            UserTO userTO = (UserTO)((UserWrapper)this.form.getModelObject()).getInnerObject();
            try {
                UserCR req = new UserCR();
                EntityTOUtils.toAnyCR((AnyTO)userTO, (AnyCR)req);
                req.setStorePassword(this.form.getModelObject() instanceof UserWrapper ? ((UserWrapper)UserWrapper.class.cast(this.form.getModelObject())).isStorePasswordInSyncope() : StringUtils.isNotBlank((CharSequence)userTO.getPassword()));
                ProvisioningResult<UserTO> provisioningResult = ProvisioningUtils.createUser(req);
                this.setResponsePage((IRequestablePage)new SelfResult(provisioningResult, ProvisioningUtils.managePageParams((Component)this, "profile.change", !SyncopeWebApplication.get().isReportPropagationErrors() || provisioningResult.getPropagationStatuses().stream().allMatch(ps -> ExecStatus.SUCCESS == ps.getStatus()))));
            }
            catch (SyncopeClientException e) {
                LOG.error("While creating user {}", (Object)userTO.getUsername(), (Object)e);
                SyncopeEnduserSession.get().onException((Exception)((Object)e));
                ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }
    }

    protected void loadSecurityQuestion(PageReference pageRef, AjaxRequestTarget target) {
        try {
            SecurityQuestionTO securityQuestionTO = SyncopeEnduserSession.get().getService(SecurityQuestionService.class).readByUser(this.usernameText);
            this.securityQuestion.setModel((IModel)Model.of((Serializable)((Object)securityQuestionTO.getContent())));
            target.add(new Component[]{this.securityQuestion});
        }
        catch (Exception e) {
            LOG.error("Unable to get security question for [{}]", (Object)this.usernameText, (Object)e);
            SyncopeEnduserSession.get().onException(e);
            ((BaseWebPage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }
}

