/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.AbstractCentralAuthenticationService;
import org.apereo.cas.CentralAuthenticationServiceContext;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.DefaultAuthenticationBuilder;
import org.apereo.cas.authentication.exceptions.MixedPrincipalException;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.services.CasModelRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ServiceContext;
import org.apereo.cas.services.UnauthorizedProxyingException;
import org.apereo.cas.services.UnauthorizedSsoServiceException;
import org.apereo.cas.support.events.ticket.CasProxyGrantingTicketCreatedEvent;
import org.apereo.cas.support.events.ticket.CasProxyTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketValidatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.RenewableServiceTicket;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketFactory;
import org.apereo.cas.ticket.UnrecognizableServiceForServiceTicketValidationException;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.ticket.proxy.ProxyTicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.validation.Assertion;
import org.apereo.cas.validation.DefaultAssertionBuilder;
import org.apereo.inspektr.audit.annotation.Audit;
import org.apereo.services.persondir.support.merger.IAttributeMerger;
import org.jooq.lambda.Unchecked;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class DefaultCentralAuthenticationService
extends AbstractCentralAuthenticationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCentralAuthenticationService.class);
    private static final long serialVersionUID = -8943828074939533986L;

    public DefaultCentralAuthenticationService(CentralAuthenticationServiceContext context) {
        super(context);
    }

    private static Authentication evaluatePossibilityOfMixedPrincipals(AuthenticationResult context, TicketGrantingTicket ticketGrantingTicket) {
        if (context == null) {
            LOGGER.warn("Provided authentication result is undefined to evaluate for mixed principals");
            return null;
        }
        Authentication currentAuthentication = context.getAuthentication();
        if (currentAuthentication != null) {
            Authentication original = ticketGrantingTicket.getAuthentication();
            if (!currentAuthentication.getPrincipal().equals(original.getPrincipal())) {
                throw new MixedPrincipalException(currentAuthentication, currentAuthentication.getPrincipal(), original.getPrincipal());
            }
        }
        return currentAuthentication;
    }

    @Audit(action="SERVICE_TICKET", actionResolverName="GRANT_SERVICE_TICKET_RESOLVER", resourceResolverName="GRANT_SERVICE_TICKET_RESOURCE_RESOLVER")
    public ServiceTicket grantServiceTicket(final String ticketGrantingTicketId, final Service service, final AuthenticationResult authenticationResult) throws AuthenticationException, AbstractTicketException {
        final boolean credentialProvided = authenticationResult != null && authenticationResult.isCredentialProvided();
        return (ServiceTicket)this.configurationContext.getLockRepository().execute((Object)ticketGrantingTicketId, Unchecked.supplier((CheckedSupplier)new CheckedSupplier<ServiceTicket>(){

            public ServiceTicket get() throws Throwable {
                TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().getTicket(ticketGrantingTicketId, TicketGrantingTicket.class);
                WebApplicationService selectedService = DefaultCentralAuthenticationService.this.resolveServiceFromAuthenticationRequest(service);
                RegisteredService registeredService = DefaultCentralAuthenticationService.this.configurationContext.getServicesManager().findServiceBy((Service)selectedService);
                Authentication currentAuthentication = DefaultCentralAuthenticationService.evaluatePossibilityOfMixedPrincipals(authenticationResult, ticketGrantingTicket);
                RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)registeredService, (Service)selectedService, (TicketGrantingTicket)ticketGrantingTicket, (boolean)credentialProvided);
                DefaultCentralAuthenticationService.this.evaluateProxiedServiceIfNeeded((Service)selectedService, ticketGrantingTicket, registeredService);
                DefaultCentralAuthenticationService.this.getAuthenticationSatisfiedByPolicy(currentAuthentication, new ServiceContext((Service)selectedService, registeredService));
                Authentication latestAuthentication = ticketGrantingTicket.getRoot().getAuthentication();
                AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)latestAuthentication);
                Principal principal = latestAuthentication.getPrincipal();
                RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(principal).build();
                IAttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)PrincipalAttributesCoreProperties.MergingStrategyTypes.MULTIVALUED);
                Map policyAttributes = registeredService.getAttributeReleasePolicy().getAttributes(releasePolicyContext);
                Map accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)principal.getAttributes(), (Map)latestAuthentication.getAttributes(), (IAttributeMerger)merger);
                accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)policyAttributes, (IAttributeMerger)merger);
                Principal accessPrincipal = DefaultCentralAuthenticationService.this.configurationContext.getPrincipalFactory().createPrincipal(principal.getId(), accessAttributes);
                DefaultCentralAuthenticationService.this.enforceRegisteredServiceAccess((Service)selectedService, registeredService, accessPrincipal);
                ServiceTicketFactory factory = (ServiceTicketFactory)DefaultCentralAuthenticationService.this.configurationContext.getTicketFactory().get(ServiceTicket.class);
                ServiceTicket serviceTicket = (ServiceTicket)factory.create(ticketGrantingTicket, (Service)selectedService, credentialProvided, ServiceTicket.class);
                DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().updateTicket((Ticket)ticketGrantingTicket);
                DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().addTicket((Ticket)serviceTicket);
                LOGGER.info("Granted service ticket [{}] for service [{}] and principal [{}]", new Object[]{serviceTicket.getId(), DigestUtils.abbreviate((String)selectedService.getId()), principal.getId()});
                DefaultCentralAuthenticationService.this.doPublishEvent((ApplicationEvent)new CasServiceTicketGrantedEvent((Object)this, ticketGrantingTicket, serviceTicket));
                return serviceTicket;
            }
        })).orElseThrow(() -> new InvalidTicketException(ticketGrantingTicketId));
    }

    @Audit(action="PROXY_TICKET", actionResolverName="GRANT_PROXY_TICKET_RESOLVER", resourceResolverName="GRANT_PROXY_TICKET_RESOURCE_RESOLVER")
    public ProxyTicket grantProxyTicket(String proxyGrantingTicket, final Service service) throws AbstractTicketException {
        final ProxyGrantingTicket proxyGrantingTicketObject = (ProxyGrantingTicket)this.configurationContext.getTicketRegistry().getTicket(proxyGrantingTicket, ProxyGrantingTicket.class);
        RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy(service);
        try {
            this.enforceRegisteredServiceAccess(service, (TicketGrantingTicket)proxyGrantingTicketObject, registeredService);
            RegisteredServiceAccessStrategyUtils.ensureServiceSsoAccessIsAllowed((RegisteredService)registeredService, (Service)service, (TicketGrantingTicket)proxyGrantingTicketObject);
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
            throw new UnauthorizedSsoServiceException();
        }
        this.evaluateProxiedServiceIfNeeded(service, (TicketGrantingTicket)proxyGrantingTicketObject, registeredService);
        this.getAuthenticationSatisfiedByPolicy(proxyGrantingTicketObject.getRoot().getAuthentication(), new ServiceContext(service, registeredService));
        final Authentication authentication = proxyGrantingTicketObject.getRoot().getAuthentication();
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
        return (ProxyTicket)this.configurationContext.getLockRepository().execute((Object)proxyGrantingTicketObject.getId(), Unchecked.supplier((CheckedSupplier)new CheckedSupplier<ProxyTicket>(){

            public ProxyTicket get() throws Throwable {
                Principal principal = authentication.getPrincipal();
                ProxyTicketFactory factory = (ProxyTicketFactory)DefaultCentralAuthenticationService.this.configurationContext.getTicketFactory().get(ProxyTicket.class);
                ProxyTicket proxyTicket = (ProxyTicket)factory.create(proxyGrantingTicketObject, service, ProxyTicket.class);
                DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().updateTicket((Ticket)proxyGrantingTicketObject);
                DefaultCentralAuthenticationService.this.configurationContext.getTicketRegistry().addTicket((Ticket)proxyTicket);
                LOGGER.info("Granted proxy ticket [{}] for service [{}] for user [{}]", new Object[]{proxyTicket.getId(), service.getId(), principal.getId()});
                DefaultCentralAuthenticationService.this.doPublishEvent((ApplicationEvent)new CasProxyTicketGrantedEvent((Object)this, proxyGrantingTicketObject, proxyTicket));
                return proxyTicket;
            }
        })).orElseThrow(UnauthorizedProxyingException::new);
    }

    @Audit(action="PROXY_GRANTING_TICKET", actionResolverName="CREATE_PROXY_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER")
    public ProxyGrantingTicket createProxyGrantingTicket(String serviceTicketId, AuthenticationResult authenticationResult) throws AuthenticationException, AbstractTicketException {
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authenticationResult.getAuthentication());
        ServiceTicket serviceTicket = (ServiceTicket)this.configurationContext.getTicketRegistry().getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            LOGGER.debug("ServiceTicket [{}] has expired or cannot be found in the ticket registry", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        CasModelRegisteredService registeredService = (CasModelRegisteredService)this.configurationContext.getServicesManager().findServiceBy(serviceTicket.getService());
        AuditableContext ctx = AuditableContext.builder().serviceTicket(serviceTicket).authenticationResult(authenticationResult).registeredService((RegisteredService)registeredService).build();
        AuditableExecutionResult result = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(ctx);
        result.throwExceptionIfNeeded();
        if (!registeredService.getProxyPolicy().isAllowedToProxy()) {
            LOGGER.warn("Service [{}] attempted to proxy, but is not allowed.", (Object)serviceTicket.getService().getId());
            throw new UnauthorizedProxyingException();
        }
        return (ProxyGrantingTicket)this.configurationContext.getLockRepository().execute((Object)serviceTicket.getId(), Unchecked.supplier(() -> {
            Authentication authentication = authenticationResult.getAuthentication();
            ProxyGrantingTicketFactory factory = (ProxyGrantingTicketFactory)this.configurationContext.getTicketFactory().get(ProxyGrantingTicket.class);
            ProxyGrantingTicket proxyGrantingTicket = factory.create(serviceTicket, authentication, ProxyGrantingTicket.class);
            LOGGER.debug("Generated proxy granting ticket [{}] based off of [{}]", (Object)proxyGrantingTicket, (Object)serviceTicketId);
            this.configurationContext.getTicketRegistry().addTicket((Ticket)proxyGrantingTicket);
            this.configurationContext.getTicketRegistry().updateTicket((Ticket)serviceTicket.getTicketGrantingTicket());
            this.doPublishEvent((ApplicationEvent)new CasProxyGrantingTicketCreatedEvent((Object)this, (TicketGrantingTicket)proxyGrantingTicket));
            return proxyGrantingTicket;
        })).orElseThrow(UnauthorizedProxyingException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Audit(action="SERVICE_TICKET_VALIDATE", actionResolverName="VALIDATE_SERVICE_TICKET_RESOLVER", resourceResolverName="VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER")
    public Assertion validateServiceTicket(String serviceTicketId, Service service) throws AbstractTicketException {
        if (!this.isTicketAuthenticityVerified(serviceTicketId)) {
            LOGGER.info("Service ticket [{}] is not a valid ticket issued by CAS.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        ServiceTicket serviceTicket = (ServiceTicket)this.configurationContext.getTicketRegistry().getTicket(serviceTicketId, ServiceTicket.class);
        if (serviceTicket == null) {
            LOGGER.warn("Service ticket [{}] does not exist.", (Object)serviceTicketId);
            throw new InvalidTicketException(serviceTicketId);
        }
        try {
            WebApplicationService selectedService = this.resolveServiceFromAuthenticationRequest(serviceTicket.getService());
            WebApplicationService resolvedService = this.resolveServiceFromAuthenticationRequest(service);
            LOGGER.debug("Resolved service [{}] from the authentication request with service [{}] linked to service ticket [{}]", new Object[]{resolvedService, selectedService, serviceTicket.getId()});
            this.configurationContext.getLockRepository().execute((Object)serviceTicket.getId(), Unchecked.supplier(() -> {
                if (serviceTicket.isExpired()) {
                    LOGGER.info("ServiceTicket [{}] has expired.", (Object)serviceTicketId);
                    throw new InvalidTicketException(serviceTicketId);
                }
                if (!this.configurationContext.getServiceMatchingStrategy().matches((Service)selectedService, (Service)resolvedService)) {
                    LOGGER.error("Service ticket [{}] with service [{}] does not match supplied service [{}]", new Object[]{serviceTicketId, serviceTicket.getService().getId(), resolvedService.getId()});
                    throw new UnrecognizableServiceForServiceTicketValidationException((Service)selectedService);
                }
                serviceTicket.update();
                this.configurationContext.getTicketRegistry().updateTicket((Ticket)serviceTicket);
                return serviceTicket;
            }));
            RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy((Service)selectedService);
            LOGGER.trace("Located registered service definition [{}] from [{}] to handle validation request", (Object)registeredService, (Object)selectedService);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)selectedService, (RegisteredService)registeredService);
            TicketGrantingTicket root = serviceTicket.getTicketGrantingTicket().getRoot();
            Authentication authentication = this.getAuthenticationSatisfiedByPolicy(root.getAuthentication(), new ServiceContext((Service)selectedService, registeredService));
            Principal principal = authentication.getPrincipal();
            RegisteredServiceAttributeReleasePolicy attributePolicy = Objects.requireNonNull(registeredService.getAttributeReleasePolicy());
            LOGGER.debug("Attribute policy [{}] is associated with service [{}]", (Object)attributePolicy, (Object)registeredService);
            RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service((Service)selectedService).principal(principal).build();
            Map attributesToRelease = attributePolicy.getAttributes(context);
            LOGGER.debug("Calculated attributes for release per the release policy are [{}]", attributesToRelease.keySet());
            String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(principal, (Service)selectedService, registeredService);
            AuthenticationBuilder builder = DefaultAuthenticationBuilder.of((Principal)principal, (PrincipalFactory)this.configurationContext.getPrincipalFactory(), (Map)attributesToRelease, (Service)selectedService, (RegisteredService)registeredService, (Authentication)authentication);
            LOGGER.debug("Principal determined for release to [{}] is [{}]", (Object)registeredService.getServiceId(), (Object)principalId);
            builder.addAttribute("isFromNewLogin", CollectionUtils.wrap((Object)((RenewableServiceTicket)serviceTicket).isFromNewLogin()));
            builder.addAttribute("longTermAuthenticationRequestTokenUsed", CollectionUtils.wrap((Object)CoreAuthenticationUtils.isRememberMeAuthentication((Authentication)authentication)));
            Authentication finalAuthentication = builder.build();
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(principal).build();
            Map policyAttributes = registeredService.getAttributeReleasePolicy().getAttributes(releasePolicyContext);
            IAttributeMerger merger = CoreAuthenticationUtils.getAttributeMerger((PrincipalAttributesCoreProperties.MergingStrategyTypes)PrincipalAttributesCoreProperties.MergingStrategyTypes.MULTIVALUED);
            Map accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)principal.getAttributes(), (Map)authentication.getAttributes(), (IAttributeMerger)merger);
            accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)finalAuthentication.getPrincipal().getAttributes(), (IAttributeMerger)merger);
            accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)finalAuthentication.getAttributes(), (IAttributeMerger)merger);
            accessAttributes = CoreAuthenticationUtils.mergeAttributes((Map)accessAttributes, (Map)policyAttributes, (IAttributeMerger)merger);
            Principal accessPrincipal = this.configurationContext.getPrincipalFactory().createPrincipal(principal.getId(), accessAttributes);
            this.enforceRegisteredServiceAccess((Service)selectedService, registeredService, accessPrincipal);
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)finalAuthentication);
            Assertion assertion = DefaultAssertionBuilder.builder().primaryAuthentication(finalAuthentication).service(selectedService).registeredService(registeredService).authentications(serviceTicket.getTicketGrantingTicket().getChainedAuthentications()).newLogin(((RenewableServiceTicket)serviceTicket).isFromNewLogin()).build().assemble();
            this.doPublishEvent((ApplicationEvent)new CasServiceTicketValidatedEvent((Object)this, serviceTicket, assertion));
            Assertion assertion2 = assertion;
            return assertion2;
        }
        finally {
            FunctionUtils.doUnchecked(s -> {
                if (serviceTicket.isExpired()) {
                    this.configurationContext.getTicketRegistry().deleteTicket(serviceTicketId);
                } else {
                    this.configurationContext.getTicketRegistry().updateTicket((Ticket)serviceTicket);
                }
            }, (Object[])new Object[0]);
        }
    }

    @Audit(action="TICKET_GRANTING_TICKET", actionResolverName="CREATE_TICKET_GRANTING_TICKET_RESOLVER", resourceResolverName="CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER")
    public TicketGrantingTicket createTicketGrantingTicket(AuthenticationResult authenticationResult) throws AuthenticationException, AbstractTicketException {
        Authentication authentication = authenticationResult.getAuthentication();
        Service service = authenticationResult.getService();
        AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authentication);
        if (service != null) {
            service = this.resolveServiceFromAuthenticationRequest(service);
            LOGGER.debug("Resolved service [{}] from the authentication request", (Object)service);
            RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy(service);
            this.enforceRegisteredServiceAccess(authentication, service, registeredService);
        }
        TicketGrantingTicketFactory factory = (TicketGrantingTicketFactory)this.configurationContext.getTicketFactory().get(TicketGrantingTicket.class);
        TicketGrantingTicket ticketGrantingTicket = factory.create(authentication, service, TicketGrantingTicket.class);
        FunctionUtils.doUnchecked(s -> {
            this.configurationContext.getTicketRegistry().addTicket((Ticket)ticketGrantingTicket);
            this.doPublishEvent((ApplicationEvent)new CasTicketGrantingTicketCreatedEvent((Object)this, ticketGrantingTicket));
        }, (Object[])new Object[0]);
        return ticketGrantingTicket;
    }

    private void enforceRegisteredServiceAccess(Authentication authentication, Service service, RegisteredService registeredService) {
        AuditableContext audit = AuditableContext.builder().service(service).authentication(authentication).registeredService(registeredService).build();
        AuditableExecutionResult accessResult = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
    }

    private void enforceRegisteredServiceAccess(Service service, RegisteredService registeredService, Principal principal) {
        AuditableContext audit = AuditableContext.builder().service(service).principal(principal).registeredService(registeredService).build();
        AuditableExecutionResult accessResult = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
    }

    private void enforceRegisteredServiceAccess(Service service, TicketGrantingTicket ticket, RegisteredService registeredService) {
        AuditableContext audit = AuditableContext.builder().service(service).ticketGrantingTicket(ticket).registeredService(registeredService).build();
        AuditableExecutionResult accessResult = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
    }
}

