/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.WebBasedRegisteredService;
import org.apereo.cas.services.web.CasThemeResourceBundleMessageSource;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class RegisteredServiceThemeResolver
extends AbstractThemeResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceThemeResolver.class);
    private final ObjectProvider<ServicesManager> servicesManager;
    private final ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    private final ObjectProvider<CasConfigurationProperties> casProperties;

    @Nonnull
    public String resolveThemeName(@Nonnull HttpServletRequest request) {
        RequestContext context = RequestContextHolder.getRequestContext();
        WebApplicationService serviceContext = WebUtils.getService((RequestContext)context);
        Service service = ((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject()).resolveService((Service)serviceContext);
        if (service == null) {
            LOGGER.trace("No service is found in the request context. Falling back to the default theme [{}]", (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        WebBasedRegisteredService rService = (WebBasedRegisteredService)((ServicesManager)this.servicesManager.getObject()).findServiceBy(service);
        if (rService == null || !rService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("No registered service is found to match [{}] or access is denied. Using default theme [{}]", (Object)service, (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        if (StringUtils.isBlank((CharSequence)rService.getTheme())) {
            LOGGER.trace("No theme name is specified for service [{}]. Using default theme [{}]", (Object)rService, (Object)this.getDefaultThemeName());
            return this.rememberThemeName(request);
        }
        String themeName = this.determineThemeNameToChoose(request, service, rService);
        return this.rememberThemeName(request, themeName);
    }

    public void setThemeName(@Nonnull HttpServletRequest request, HttpServletResponse response, String themeName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String determineThemeNameToChoose(HttpServletRequest request, Service service, WebBasedRegisteredService rService) {
        HttpResponse response = null;
        try {
            block14: {
                String theme;
                block13: {
                    LOGGER.debug("Service [{}] is configured to use a custom theme [{}]", (Object)rService, (Object)rService.getTheme());
                    AbstractResource resource = ResourceUtils.getRawResourceFrom((String)rService.getTheme());
                    if (resource instanceof FileSystemResource && resource.exists()) {
                        LOGGER.debug("Executing groovy script to determine theme for [{}]", (Object)service.getId());
                        String result = (String)ScriptingUtils.executeGroovyScript((Resource)resource, (Object[])new Object[]{service, rService, request.getQueryString(), HttpRequestUtils.getRequestHeaders((HttpServletRequest)request), LOGGER}, String.class, (boolean)true);
                        String string = (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)this.getDefaultThemeName());
                        HttpUtils.close((HttpResponse)response);
                        return string;
                    }
                    if (!(resource instanceof UrlResource)) break block13;
                    String url = resource.getURL().toExternalForm();
                    LOGGER.debug("Executing URL [{}] to determine theme for [{}]", (Object)url, (Object)service.getId());
                    HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().parameters(CollectionUtils.wrap((String)"service", (Object)service.getId())).url(url).method(HttpMethod.GET).build();
                    response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                    if (response != null && response.getStatusLine().getStatusCode() == 200) break block14;
                }
                if ((theme = this.resolveThemeForService(rService, request)) != null) {
                    LOGGER.trace("Found custom theme [{}] for service [{}]", (Object)theme, (Object)rService);
                    String string = theme;
                    return string;
                }
                LOGGER.warn("Custom theme [{}] for service [{}] cannot be located. Falling back to default theme...", (Object)rService.getTheme(), (Object)rService.getName());
                return this.getDefaultThemeName();
            }
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            String string = (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)this.getDefaultThemeName());
            HttpUtils.close((HttpResponse)response);
            return string;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return this.getDefaultThemeName();
        }
        finally {
            HttpUtils.close(response);
        }
    }

    protected String rememberThemeName(HttpServletRequest request) {
        return this.rememberThemeName(request, this.getDefaultThemeName());
    }

    protected String rememberThemeName(HttpServletRequest request, String themeName) {
        String attributeName = ((CasConfigurationProperties)this.casProperties.getObject()).getTheme().getParamName();
        LOGGER.trace("Storing theme [{}] as a request attribute under [{}]", (Object)themeName, (Object)attributeName);
        request.setAttribute(attributeName, (Object)themeName);
        return themeName;
    }

    protected String resolveThemeForService(WebBasedRegisteredService registeredService, HttpServletRequest request) {
        CasThemeResourceBundleMessageSource messageSource = new CasThemeResourceBundleMessageSource();
        String theme = SpringExpressionLanguageValueResolver.getInstance().resolve(registeredService.getTheme());
        messageSource.setBasename(theme);
        if (((CasConfigurationProperties)this.casProperties.getObject()).getView().getTemplatePrefixes().stream().map(prefix -> StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]).concat(theme).concat(".properties")).anyMatch(ResourceUtils::doesResourceExist)) {
            LOGGER.trace("Found custom extrnal theme [{}] for service [{}]", (Object)theme, (Object)registeredService.getName());
            return theme;
        }
        if (messageSource.doGetBundle(theme, request.getLocale()) != null) {
            LOGGER.trace("Found custom theme [{}] for service [{}]", (Object)theme, (Object)registeredService.getName());
            return theme;
        }
        LOGGER.warn("Theme [{}] for service [{}] cannot be located", (Object)theme, (Object)registeredService.getName());
        return null;
    }

    @Generated
    public RegisteredServiceThemeResolver(ObjectProvider<ServicesManager> servicesManager, ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies, ObjectProvider<CasConfigurationProperties> casProperties) {
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.casProperties = casProperties;
    }
}

