/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.pac4j.saml;

import java.util.Base64;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.syncope.common.lib.to.SAML2SPEntityTO;
import org.apache.syncope.common.rest.api.service.SAML2SPEntityService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;
import org.pac4j.saml.client.SAML2Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WASAML2MetadataResolver
extends AbstractReloadingMetadataResolver {
    private static final Logger LOG = LoggerFactory.getLogger(WASAML2MetadataResolver.class);
    private final WARestClient restClient;
    private final SAML2Client saml2Client;

    WASAML2MetadataResolver(WARestClient restClient, SAML2Client saml2Client) {
        this.restClient = restClient;
        this.saml2Client = saml2Client;
    }

    protected String getMetadataIdentifier() {
        return this.saml2Client.getName();
    }

    protected byte[] fetchMetadata() throws ResolverException {
        try {
            SAML2SPEntityTO metadataTO = ((SAML2SPEntityService)this.restClient.getSyncopeClient().getService(SAML2SPEntityService.class)).get(this.saml2Client.getName());
            return Base64.getDecoder().decode(metadataTO.getMetadata());
        }
        catch (Exception e) {
            String message = "Unable to fetch SP metadata for " + this.saml2Client.getName();
            LOG.error(message, (Throwable)e);
            throw new ResolverException(message);
        }
    }
}

