/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyConf;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.wa.starter.mapping.AccessMapper;
import org.apache.syncope.wa.starter.mapping.AttrReleaseMapper;
import org.apache.syncope.wa.starter.mapping.AuthMapper;
import org.apache.syncope.wa.starter.mapping.AuthMapperResult;
import org.apache.syncope.wa.starter.mapping.ClientAppMapper;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ConfigurableApplicationContext;

public class RegisteredServiceMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RegisteredServiceMapper.class);
    protected final ConfigurableApplicationContext ctx;
    protected final String pac4jCoreName;
    protected final ObjectProvider<AuthenticationEventExecutionPlan> authEventExecPlan;
    protected final Map<String, AuthMapper> authPolicyConfMappers;
    protected final Map<String, AccessMapper> accessPolicyConfMappers;
    protected final Map<String, AttrReleaseMapper> attrReleasePolicyConfMappers;
    protected final Map<String, ClientAppMapper> clientAppTOMappers;

    public RegisteredServiceMapper(ConfigurableApplicationContext ctx, String pac4jCoreName, ObjectProvider<AuthenticationEventExecutionPlan> authEventExecPlan, Map<String, AuthMapper> authPolicyConfMappers, Map<String, AccessMapper> accessPolicyConfMappers, Map<String, AttrReleaseMapper> attrReleasePolicyConfMappers, Map<String, ClientAppMapper> clientAppTOMappers) {
        this.ctx = ctx;
        this.pac4jCoreName = pac4jCoreName;
        this.authEventExecPlan = authEventExecPlan;
        this.authPolicyConfMappers = authPolicyConfMappers;
        this.accessPolicyConfMappers = accessPolicyConfMappers;
        this.attrReleasePolicyConfMappers = attrReleasePolicyConfMappers;
        this.clientAppTOMappers = clientAppTOMappers;
    }

    public RegisteredService toRegisteredService(WAClientApp clientApp) {
        String key = clientApp.getClientAppTO().getClass().getName();
        ClientAppMapper clientAppMapper = this.clientAppTOMappers.get(key);
        if (clientAppMapper == null) {
            LOG.warn("Unable to locate ClientAppMapper using key {}", (Object)key);
            return null;
        }
        RegisteredServiceAuthenticationPolicy authPolicy = null;
        RegisteredServiceMultifactorPolicy mfaPolicy = null;
        RegisteredServiceDelegatedAuthenticationPolicy delegatedAuthPolicy = null;
        if (clientApp.getAuthPolicy() != null) {
            AuthMapper authMapper = this.authPolicyConfMappers.get(clientApp.getAuthPolicy().getConf().getClass().getName());
            AuthMapperResult result = Optional.ofNullable(authMapper).map(mapper -> mapper.build(this.ctx, this.pac4jCoreName, this.authEventExecPlan, clientApp.getAuthPolicy(), clientApp.getAuthModules())).orElseGet(() -> new AuthMapperResult(null, null, null));
            authPolicy = result.getAuthPolicy();
            mfaPolicy = result.getMfaPolicy();
            delegatedAuthPolicy = result.getDelegateAuthPolicy();
        }
        DefaultRegisteredServiceAccessStrategy accessStrategy = null;
        if (clientApp.getAccessPolicy() != null) {
            AccessMapper accessPolicyConfMapper = this.accessPolicyConfMappers.get(clientApp.getAccessPolicy().getConf().getClass().getName());
            accessStrategy = Optional.ofNullable(accessPolicyConfMapper).map(mapper -> mapper.build(clientApp.getAccessPolicy())).orElse(null);
        }
        if (delegatedAuthPolicy != null) {
            if (accessStrategy == null) {
                accessStrategy = new DefaultRegisteredServiceAccessStrategy();
            }
            if (accessStrategy instanceof DefaultRegisteredServiceAccessStrategy) {
                accessStrategy.setDelegatedAuthenticationPolicy(delegatedAuthPolicy);
            } else {
                LOG.warn("Could not set delegated auth policy because access strategy is instance of {}", (Object)accessStrategy.getClass().getName());
            }
        }
        AttrReleasePolicyTO attrReleasePolicyTO = Optional.ofNullable(clientApp.getAttrReleasePolicy()).orElseGet(() -> {
            AttrReleasePolicyTO arpTO = new AttrReleasePolicyTO();
            arpTO.setConf((AttrReleasePolicyConf)new DefaultAttrReleasePolicyConf());
            return arpTO;
        });
        AttrReleaseMapper attrReleasePolicyConfMapper = this.attrReleasePolicyConfMappers.get(attrReleasePolicyTO.getConf().getClass().getName());
        RegisteredServiceAttributeReleasePolicy attributeReleasePolicy = Optional.ofNullable(attrReleasePolicyConfMapper).map(mapper -> mapper.build(attrReleasePolicyTO, clientApp.getReleaseAttrs())).orElse(null);
        return clientAppMapper.map(this.ctx, clientApp, authPolicy, mfaPolicy, (RegisteredServiceAccessStrategy)accessStrategy, attributeReleasePolicy);
    }
}

