/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.lib.types.OIDCResponseType;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.wa.starter.mapping.AbstractClientAppMapper;
import org.apache.syncope.wa.starter.mapping.ClientAppMapFor;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.BaseWebBasedRegisteredService;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.springframework.context.ConfigurableApplicationContext;

@ClientAppMapFor(clientAppClass=OIDCRPClientAppTO.class)
public class OIDCRPClientAppTOMapper
extends AbstractClientAppMapper {
    private static final String CUSTOM_SCOPE = "syncope";

    @Override
    public RegisteredService map(ConfigurableApplicationContext ctx, WAClientApp clientApp, RegisteredServiceAuthenticationPolicy authPolicy, RegisteredServiceMultifactorPolicy mfaPolicy, RegisteredServiceAccessStrategy accessStrategy, RegisteredServiceAttributeReleasePolicy attributeReleasePolicy) {
        ChainingAttributeReleasePolicy chain;
        OIDCRPClientAppTO rp = (OIDCRPClientAppTO)OIDCRPClientAppTO.class.cast(clientApp.getClientAppTO());
        OidcRegisteredService service = new OidcRegisteredService();
        this.setCommon((BaseWebBasedRegisteredService)service, (ClientAppTO)rp);
        service.setServiceId(rp.getRedirectUris().stream().filter(Objects::nonNull).collect(Collectors.joining("|")));
        service.setClientId(rp.getClientId());
        service.setClientSecret(rp.getClientSecret());
        service.setSignIdToken(rp.isSignIdToken());
        if (!service.isSignIdToken()) {
            service.setIdTokenSigningAlg("none");
        }
        service.setJwtAccessToken(rp.isJwtAccessToken());
        service.setBypassApprovalPrompt(rp.isBypassApprovalPrompt());
        service.setSupportedGrantTypes((Set)rp.getSupportedGrantTypes().stream().map(Enum::name).collect(Collectors.toCollection(HashSet::new)));
        service.setSupportedResponseTypes((Set)rp.getSupportedResponseTypes().stream().map(OIDCResponseType::getExternalForm).collect(Collectors.toCollection(HashSet::new)));
        if (rp.getSubjectType() != null) {
            service.setSubjectType(rp.getSubjectType().name());
        }
        service.setLogoutUrl(rp.getLogoutUri());
        if (attributeReleasePolicy instanceof ChainingAttributeReleasePolicy) {
            chain = (ChainingAttributeReleasePolicy)attributeReleasePolicy;
        } else {
            chain = new ChainingAttributeReleasePolicy();
            if (attributeReleasePolicy != null) {
                chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{attributeReleasePolicy});
            }
            chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcProfileScopeAttributeReleasePolicy(), new OidcEmailScopeAttributeReleasePolicy(), new OidcAddressScopeAttributeReleasePolicy(), new OidcPhoneScopeAttributeReleasePolicy()});
            Set customClaims = clientApp.getReleaseAttrs().values().stream().map(Objects::toString).collect(Collectors.toCollection(HashSet::new));
            customClaims.removeAll(OidcProfileScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            customClaims.removeAll(OidcEmailScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            customClaims.removeAll(OidcAddressScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            customClaims.removeAll(OidcPhoneScopeAttributeReleasePolicy.ALLOWED_CLAIMS);
            if (!customClaims.isEmpty()) {
                CasConfigurationProperties properties = (CasConfigurationProperties)ctx.getBean(CasConfigurationProperties.class);
                List supportedClaims = properties.getAuthn().getOidc().getDiscovery().getClaims();
                if (!supportedClaims.containsAll(customClaims)) {
                    properties.getAuthn().getOidc().getDiscovery().setClaims(Stream.concat(supportedClaims.stream(), customClaims.stream()).distinct().collect(Collectors.toList()));
                }
                chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{new OidcCustomScopeAttributeReleasePolicy(CUSTOM_SCOPE, customClaims.stream().collect(Collectors.toList()))});
            }
        }
        this.setPolicies((BaseWebBasedRegisteredService)service, authPolicy, mfaPolicy, accessStrategy, (RegisteredServiceAttributeReleasePolicy)chain);
        return service;
    }
}

