/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.mapping;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.auth.MFAAuthModuleConf;
import org.apache.syncope.common.lib.auth.Pac4jAuthModuleConf;
import org.apache.syncope.common.lib.policy.AuthPolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAuthPolicyConf;
import org.apache.syncope.common.lib.to.AuthModuleTO;
import org.apache.syncope.wa.starter.mapping.AuthMapFor;
import org.apache.syncope.wa.starter.mapping.AuthMapper;
import org.apache.syncope.wa.starter.mapping.AuthMapperResult;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.services.AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.DefaultRegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceAuthenticationPolicyCriteria;
import org.apereo.cas.services.RegisteredServiceDelegatedAuthenticationPolicy;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ConfigurableApplicationContext;

@AuthMapFor(authPolicyConfClass=DefaultAuthPolicyConf.class)
public class DefaultAuthMapper
implements AuthMapper {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultAuthMapper.class);

    @Override
    public AuthMapperResult build(ConfigurableApplicationContext ctx, String pac4jCoreName, ObjectProvider<AuthenticationEventExecutionPlan> authEventExecPlan, AuthPolicyTO policy, List<AuthModuleTO> authModules) {
        DefaultRegisteredServiceAuthenticationPolicy authPolicy = new DefaultRegisteredServiceAuthenticationPolicy();
        HashSet mfaAuthHandlers = new HashSet();
        HashSet delegatedAuthHandlers = new HashSet();
        DefaultAuthPolicyConf policyConf = (DefaultAuthPolicyConf)policy.getConf();
        if (!policyConf.getAuthModules().isEmpty()) {
            HashSet<String> authHandlers = new HashSet<String>(policyConf.getAuthModules());
            mfaAuthHandlers.addAll(((AuthenticationEventExecutionPlan)authEventExecPlan.getObject()).getAuthenticationHandlers().stream().filter(MultifactorAuthenticationHandler.class::isInstance).filter(mfaAuthHander -> policyConf.getAuthModules().contains(mfaAuthHander.getName())).map(AuthenticationHandler::getName).collect(Collectors.toSet()));
            authHandlers.removeAll(mfaAuthHandlers);
            delegatedAuthHandlers.addAll(authModules.stream().filter(m -> m.getConf() instanceof Pac4jAuthModuleConf).map(m -> Pair.of((Object)m.getKey(), (Object)Optional.ofNullable(((Pac4jAuthModuleConf)m.getConf()).getClientName()).orElse(m.getKey()))).collect(Collectors.toSet()));
            if (!delegatedAuthHandlers.isEmpty()) {
                authHandlers.removeAll(delegatedAuthHandlers.stream().map(Pair::getLeft).collect(Collectors.toSet()));
                authHandlers.add(pac4jCoreName);
            }
            authPolicy.setRequiredAuthenticationHandlers(authHandlers);
        }
        AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria criteria = new AnyAuthenticationHandlerRegisteredServiceAuthenticationPolicyCriteria();
        criteria.setTryAll(policyConf.isTryAll());
        authPolicy.setCriteria((RegisteredServiceAuthenticationPolicyCriteria)criteria);
        DefaultRegisteredServiceMultifactorPolicy mfaPolicy = null;
        if (!mfaAuthHandlers.isEmpty()) {
            Set fns = mfaAuthHandlers.stream().map(handler -> authModules.stream().filter(am -> handler.equals(am.getKey())).findFirst()).filter(Optional::isPresent).map(Optional::get).filter(am -> am.getConf() instanceof MFAAuthModuleConf).map(am -> ((MFAAuthModuleConf)am.getConf()).getFriendlyName()).collect(Collectors.toSet());
            Set mfaProviders = ctx.getBeansOfType(MultifactorAuthenticationProvider.class).values().stream().filter(map -> fns.contains(map.getFriendlyName())).map(MultifactorAuthenticationProvider::getId).collect(Collectors.toSet());
            mfaPolicy = new DefaultRegisteredServiceMultifactorPolicy();
            mfaPolicy.setBypassEnabled(false);
            mfaPolicy.setForceExecution(true);
            mfaPolicy.setMultifactorAuthenticationProviders(mfaProviders);
        }
        DefaultRegisteredServiceDelegatedAuthenticationPolicy delegatedAuthPolicy = null;
        if (!delegatedAuthHandlers.isEmpty()) {
            delegatedAuthPolicy = new DefaultRegisteredServiceDelegatedAuthenticationPolicy();
            delegatedAuthPolicy.getAllowedProviders().addAll(delegatedAuthHandlers.stream().map(Pair::getRight).collect(Collectors.toSet()));
        }
        return new AuthMapperResult((RegisteredServiceAuthenticationPolicy)authPolicy, (RegisteredServiceMultifactorPolicy)mfaPolicy, (RegisteredServiceDelegatedAuthenticationPolicy)delegatedAuthPolicy);
    }
}

