/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.rest.api.service.AuditService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.events.dao.AbstractCasEventRepository;
import org.apereo.cas.support.events.dao.CasEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAEventRepository
extends AbstractCasEventRepository {
    private static final Logger LOG = LoggerFactory.getLogger(WAEventRepository.class);
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    private final WARestClient waRestClient;

    public WAEventRepository(CasEventRepositoryFilter eventRepositoryFilter, WARestClient restClient) {
        super(eventRepositoryFilter);
        this.waRestClient = restClient;
    }

    public void put(Map<String, String> properties, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            properties.put(key, value);
        }
    }

    public CasEvent saveInternal(CasEvent event) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.debug("Syncope client is not yet ready to store audit record");
            return null;
        }
        LOG.info("Saving Cas events");
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (event.getGeoLocation() != null) {
                this.put(properties, "geoLatitude", event.getGeoLocation().getLatitude());
                this.put(properties, "geoLongitude", event.getGeoLocation().getLongitude());
                this.put(properties, "geoAccuracy", event.getGeoLocation().getAccuracy());
                this.put(properties, "geoTimestamp", event.getGeoLocation().getTimestamp());
            }
            this.put(properties, "clientIpAddress", event.getClientIpAddress());
            this.put(properties, "serverIpAddress", event.getServerIpAddress());
            String output = MAPPER.writeValueAsString(properties);
            AuditEntry auditEntry = new AuditEntry();
            auditEntry.setWho(event.getPrincipalId());
            if (event.getTimestamp() != null) {
                auditEntry.setDate(OffsetDateTime.ofInstant(Instant.ofEpochMilli(event.getTimestamp()), ZoneId.systemDefault()));
            }
            auditEntry.setOutput(output);
            AuditLoggerName auditLogger = new AuditLoggerName(AuditElements.EventCategoryType.WA, null, event.getType().toUpperCase(), String.valueOf(event.getId()), AuditElements.Result.SUCCESS);
            auditEntry.setLogger(auditLogger);
            ((AuditService)syncopeClient.getService(AuditService.class)).create(auditEntry);
        }
        catch (JsonProcessingException e) {
            LOG.error("During serialization", (Throwable)e);
        }
        return event;
    }

    public Stream<? extends CasEvent> load() {
        throw new UnsupportedOperationException("Fetching authentication events from WA is not supported");
    }
}

