/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStart;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.apache.syncope.wa.bootstrap.WAProperties;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apache.syncope.wa.starter.actuate.SyncopeCoreHealthIndicator;
import org.apache.syncope.wa.starter.actuate.SyncopeWAInfoContributor;
import org.apache.syncope.wa.starter.audit.WAAuditTrailManager;
import org.apache.syncope.wa.starter.events.WAEventRepository;
import org.apache.syncope.wa.starter.gauth.WAGoogleMfaAuthCredentialRepository;
import org.apache.syncope.wa.starter.gauth.WAGoogleMfaAuthTokenRepository;
import org.apache.syncope.wa.starter.mapping.AccessMapFor;
import org.apache.syncope.wa.starter.mapping.AccessMapper;
import org.apache.syncope.wa.starter.mapping.AttrReleaseMapFor;
import org.apache.syncope.wa.starter.mapping.AttrReleaseMapper;
import org.apache.syncope.wa.starter.mapping.AuthMapFor;
import org.apache.syncope.wa.starter.mapping.AuthMapper;
import org.apache.syncope.wa.starter.mapping.CASSPClientAppTOMapper;
import org.apache.syncope.wa.starter.mapping.ClientAppMapFor;
import org.apache.syncope.wa.starter.mapping.ClientAppMapper;
import org.apache.syncope.wa.starter.mapping.DefaultAccessMapper;
import org.apache.syncope.wa.starter.mapping.DefaultAttrReleaseMapper;
import org.apache.syncope.wa.starter.mapping.DefaultAuthMapper;
import org.apache.syncope.wa.starter.mapping.OIDCRPClientAppTOMapper;
import org.apache.syncope.wa.starter.mapping.RegisteredServiceMapper;
import org.apache.syncope.wa.starter.mapping.SAML2SPClientAppTOMapper;
import org.apache.syncope.wa.starter.oidc.WAOIDCJWKSGeneratorService;
import org.apache.syncope.wa.starter.pac4j.saml.WASAML2ClientCustomizer;
import org.apache.syncope.wa.starter.saml.idp.metadata.RestfulSamlIdPMetadataGenerator;
import org.apache.syncope.wa.starter.saml.idp.metadata.RestfulSamlIdPMetadataLocator;
import org.apache.syncope.wa.starter.services.WAServiceRegistry;
import org.apache.syncope.wa.starter.surrogate.WASurrogateAuthenticationService;
import org.apache.syncope.wa.starter.u2f.WAU2FDeviceRepository;
import org.apache.syncope.wa.starter.webauthn.WAWebAuthnCredentialRepository;
import org.apereo.cas.adaptors.u2f.storage.U2FDeviceRepository;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.LdapGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.u2f.U2FCoreMultifactorAuthenticationProperties;
import org.apereo.cas.gauth.credential.LdapGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.oidc.jwks.generator.OidcJsonWebKeystoreGeneratorService;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.CasEventRepositoryFilter;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.support.pac4j.authentication.handler.support.DelegatedClientAuthenticationHandler;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGenerator;
import org.apereo.cas.support.saml.idp.metadata.generator.SamlIdPMetadataGeneratorConfigurationContext;
import org.apereo.cas.support.saml.idp.metadata.locator.SamlIdPMetadataLocator;
import org.apereo.cas.support.saml.services.idp.metadata.SamlIdPMetadataDocument;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.webauthn.storage.WebAuthnCredentialRepository;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.ldaptive.ConnectionFactory;
import org.pac4j.core.client.Client;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(proxyBeanMethods=false)
public class WAContext {
    public static final String CUSTOM_GOOGLE_AUTHENTICATOR_ACCOUNT_REGISTRY = "customGoogleAuthenticatorAccountRegistry";

    private static String version(ConfigurableApplicationContext ctx) {
        return ctx.getEnvironment().getProperty("version");
    }

    @ConditionalOnMissingBean
    @Bean
    public OpenAPI casSwaggerOpenApi(ConfigurableApplicationContext ctx) {
        return new OpenAPI().info(new Info().title("Apache Syncope").description("Apache Syncope " + WAContext.version(ctx)).contact(new Contact().name("The Apache Syncope community").email("dev@syncope.apache.org").url("https://syncope.apache.org")).version(WAContext.version(ctx))).schemaRequirement("BasicAuthentication", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("basic")).schemaRequirement("Bearer", new SecurityScheme().type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT"));
    }

    @ConditionalOnMissingBean(name={"accessMapper"})
    @Bean
    public AccessMapper accessMapper() {
        return new DefaultAccessMapper();
    }

    @ConditionalOnMissingBean(name={"attrReleaseMapper"})
    @Bean
    public AttrReleaseMapper attrReleaseMapper() {
        return new DefaultAttrReleaseMapper();
    }

    @ConditionalOnMissingBean(name={"authMapper"})
    @Bean
    public AuthMapper authMapper() {
        return new DefaultAuthMapper();
    }

    @ConditionalOnMissingBean(name={"casSPClientAppTOMapper"})
    @Bean
    public ClientAppMapper casSPClientAppTOMapper() {
        return new CASSPClientAppTOMapper();
    }

    @ConditionalOnMissingBean(name={"oidcRPClientAppTOMapper"})
    @Bean
    public ClientAppMapper oidcRPClientAppTOMapper() {
        return new OIDCRPClientAppTOMapper();
    }

    @ConditionalOnMissingBean(name={"saml2SPClientAppTOMapper"})
    @Bean
    public ClientAppMapper saml2SPClientAppTOMapper() {
        return new SAML2SPClientAppTOMapper();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean
    @Bean
    public RegisteredServiceMapper registeredServiceMapper(ConfigurableApplicationContext ctx, CasConfigurationProperties casProperties, ObjectProvider<AuthenticationEventExecutionPlan> authenticationEventExecutionPlan) {
        HashMap<String, AuthMapper> authPolicyConfMappers = new HashMap<String, AuthMapper>();
        ctx.getBeansOfType(AuthMapper.class).forEach((name, bean) -> {
            AuthMapFor authMapFor = (AuthMapFor)ctx.findAnnotationOnBean(name, AuthMapFor.class);
            if (authMapFor != null) {
                authPolicyConfMappers.put(authMapFor.authPolicyConfClass().getName(), (AuthMapper)bean);
            }
        });
        HashMap<String, AccessMapper> accessPolicyConfMappers = new HashMap<String, AccessMapper>();
        ctx.getBeansOfType(AccessMapper.class).forEach((name, bean) -> {
            AccessMapFor accessMapFor = (AccessMapFor)ctx.findAnnotationOnBean(name, AccessMapFor.class);
            if (accessMapFor != null) {
                accessPolicyConfMappers.put(accessMapFor.accessPolicyConfClass().getName(), (AccessMapper)bean);
            }
        });
        HashMap<String, AttrReleaseMapper> attrReleasePolicyConfMappers = new HashMap<String, AttrReleaseMapper>();
        ctx.getBeansOfType(AttrReleaseMapper.class).forEach((name, bean) -> {
            AttrReleaseMapFor attrReleaseMapFor = (AttrReleaseMapFor)ctx.findAnnotationOnBean(name, AttrReleaseMapFor.class);
            if (attrReleaseMapFor != null) {
                attrReleasePolicyConfMappers.put(attrReleaseMapFor.attrReleasePolicyConfClass().getName(), (AttrReleaseMapper)bean);
            }
        });
        HashMap<String, ClientAppMapper> clientAppTOMappers = new HashMap<String, ClientAppMapper>();
        ctx.getBeansOfType(ClientAppMapper.class).forEach((name, bean) -> {
            ClientAppMapFor clientAppMapFor = (ClientAppMapFor)ctx.findAnnotationOnBean(name, ClientAppMapFor.class);
            if (clientAppMapFor != null) {
                clientAppTOMappers.put(clientAppMapFor.clientAppClass().getName(), (ClientAppMapper)bean);
            }
        });
        return new RegisteredServiceMapper(ctx, Optional.ofNullable(casProperties.getAuthn().getPac4j().getCore().getName()).orElse(DelegatedClientAuthenticationHandler.class.getSimpleName()), authenticationEventExecutionPlan, authPolicyConfMappers, accessPolicyConfMappers, attrReleasePolicyConfMappers, clientAppTOMappers);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean
    @Bean
    public ServiceRegistryExecutionPlanConfigurer syncopeServiceRegistryConfigurer(ConfigurableApplicationContext ctx, WARestClient restClient, RegisteredServiceMapper registeredServiceMapper, @Qualifier(value="serviceRegistryListeners") ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners) {
        WAServiceRegistry registry = new WAServiceRegistry(restClient, registeredServiceMapper, ctx, Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new));
        return plan -> plan.registerServiceRegistry((ServiceRegistry)registry);
    }

    @Bean
    public SamlIdPMetadataGenerator samlIdPMetadataGenerator(WARestClient restClient, SamlIdPMetadataGeneratorConfigurationContext context) {
        return new RestfulSamlIdPMetadataGenerator(context, restClient);
    }

    @Bean
    public SamlIdPMetadataLocator samlIdPMetadataLocator(WARestClient restClient) {
        return new RestfulSamlIdPMetadataLocator((CipherExecutor<String, String>)CipherExecutor.noOpOfStringToString(), (Cache<String, SamlIdPMetadataDocument>)Caffeine.newBuilder().build(), restClient);
    }

    @Bean
    public AuditTrailExecutionPlanConfigurer auditConfigurer(WARestClient restClient) {
        return plan -> plan.registerAuditTrailManager((AuditTrailManager)new WAAuditTrailManager(restClient));
    }

    @ConditionalOnMissingBean(name={"syncopeWAEventRepositoryFilter"})
    @Bean
    public CasEventRepositoryFilter syncopeWAEventRepositoryFilter() {
        return CasEventRepositoryFilter.noOp();
    }

    @Bean
    public CasEventRepository casEventRepository(WARestClient restClient, @Qualifier(value="syncopeWAEventRepositoryFilter") CasEventRepositoryFilter syncopeWAEventRepositoryFilter) {
        return new WAEventRepository(syncopeWAEventRepositoryFilter, restClient);
    }

    @Bean
    public DelegatedClientFactoryCustomizer<Client> delegatedClientCustomizer(WARestClient restClient) {
        return new WASAML2ClientCustomizer(restClient);
    }

    @Bean
    public WAGoogleMfaAuthTokenRepository oneTimeTokenAuthenticatorTokenRepository(CasConfigurationProperties casProperties, WARestClient restClient) {
        return new WAGoogleMfaAuthTokenRepository(restClient, casProperties.getAuthn().getMfa().getGauth().getCore().getTimeStepSize());
    }

    @ConditionalOnMissingBean(name={"customGoogleAuthenticatorAccountRegistry"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry(CasConfigurationProperties casProperties, @Qualifier(value="googleAuthenticatorAccountCipherExecutor") CipherExecutor<String, String> googleAuthenticatorAccountCipherExecutor, @Qualifier(value="googleAuthenticatorScratchCodesCipherExecutor") CipherExecutor<Number, Number> googleAuthenticatorScratchCodesCipherExecutor, IGoogleAuthenticator googleAuthenticatorInstance, WARestClient restClient) {
        LdapGoogleAuthenticatorMultifactorProperties ldap = casProperties.getAuthn().getMfa().getGauth().getLdap();
        if (StringUtils.isNotBlank((CharSequence)ldap.getBaseDn()) && StringUtils.isNotBlank((CharSequence)ldap.getLdapUrl()) && StringUtils.isNotBlank((CharSequence)ldap.getSearchFilter())) {
            ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
            return new LdapGoogleAuthenticatorTokenCredentialRepository(googleAuthenticatorAccountCipherExecutor, googleAuthenticatorScratchCodesCipherExecutor, googleAuthenticatorInstance, connectionFactory, ldap);
        }
        return new WAGoogleMfaAuthCredentialRepository(restClient, googleAuthenticatorInstance);
    }

    @Bean
    public OidcJsonWebKeystoreGeneratorService oidcJsonWebKeystoreGeneratorService(CasConfigurationProperties casProperties, WARestClient restClient) {
        return new WAOIDCJWKSGeneratorService(restClient, casProperties.getAuthn().getOidc().getJwks().getCore().getJwksKeyId(), casProperties.getAuthn().getOidc().getJwks().getCore().getJwksType(), casProperties.getAuthn().getOidc().getJwks().getCore().getJwksKeySize());
    }

    @Bean
    public WebAuthnCredentialRepository webAuthnCredentialRepository(CasConfigurationProperties casProperties, WARestClient restClient) {
        return new WAWebAuthnCredentialRepository(casProperties, restClient);
    }

    @Bean
    public U2FDeviceRepository u2fDeviceRepository(CasConfigurationProperties casProperties, WARestClient restClient) {
        U2FCoreMultifactorAuthenticationProperties u2f = casProperties.getAuthn().getMfa().getU2f().getCore();
        OffsetDateTime expirationDate = OffsetDateTime.now().minus(u2f.getExpireDevices(), DateTimeUtils.toChronoUnit((TimeUnit)u2f.getExpireDevicesTimeUnit()));
        LoadingCache requestStorage = Caffeine.newBuilder().expireAfterWrite(u2f.getExpireRegistrations(), u2f.getExpireRegistrationsTimeUnit()).build(key -> "");
        return new WAU2FDeviceRepository(casProperties, (LoadingCache<String, String>)requestStorage, restClient, expirationDate);
    }

    @Bean
    public SurrogateAuthenticationService surrogateAuthenticationService(WARestClient restClient) {
        return new WASurrogateAuthenticationService(restClient);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreHealthIndicator syncopeCoreHealthIndicator(WARestClient restClient) {
        return new SyncopeCoreHealthIndicator(restClient);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeWAInfoContributor syncopeWAInfoContributor(WAProperties waProperties) {
        return new SyncopeWAInfoContributor(waProperties);
    }

    @Bean
    public KeymasterStart keymasterStart() {
        return new KeymasterStart(NetworkService.Type.WA);
    }

    @Bean
    public KeymasterStop keymasterStop() {
        return new KeymasterStop(NetworkService.Type.WA);
    }
}

