/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.starter.audit;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.rest.api.service.AuditService;
import org.apache.syncope.wa.bootstrap.WARestClient;
import org.apereo.cas.audit.spi.AbstractAuditTrailManager;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;

public class WAAuditTrailManager
extends AbstractAuditTrailManager {
    private final WARestClient waRestClient;

    public WAAuditTrailManager(WARestClient restClient) {
        super(true);
        this.waRestClient = restClient;
    }

    protected void saveAuditRecord(AuditActionContext audit) {
        SyncopeClient syncopeClient = this.waRestClient.getSyncopeClient();
        if (syncopeClient == null) {
            LOG.debug("Syncope client is not yet ready to store audit record");
            return;
        }
        LOG.info("Loading application definitions");
        try {
            String output = MAPPER.writeValueAsString(Map.of("resource", audit.getResourceOperatedUpon(), "clientIpAddress", audit.getClientIpAddress(), "serverIpAddress", audit.getServerIpAddress()));
            AuditEntry auditEntry = new AuditEntry();
            auditEntry.setWho(audit.getPrincipal());
            auditEntry.setDate(audit.getWhenActionWasPerformed().toInstant().atOffset(OffsetDateTime.now().getOffset()));
            auditEntry.setOutput(output);
            AuditElements.Result result = StringUtils.containsIgnoreCase((CharSequence)audit.getActionPerformed(), (CharSequence)"fail") ? AuditElements.Result.FAILURE : AuditElements.Result.SUCCESS;
            AuditLoggerName auditLogger = new AuditLoggerName(AuditElements.EventCategoryType.WA, null, "Authentication".toUpperCase(), audit.getActionPerformed(), result);
            auditEntry.setLogger(auditLogger);
            ((AuditService)syncopeClient.getService(AuditService.class)).create(auditEntry);
        }
        catch (JsonProcessingException e) {
            LOG.error("During serialization", (Throwable)e);
        }
    }

    public Set<? extends AuditActionContext> getAuditRecords(Map<AuditTrailManager.WhereClauseFields, Object> map) {
        throw new UnsupportedOperationException("Fetching audit events from WA is not supported");
    }

    public void removeAll() {
        throw new UnsupportedOperationException("Removing audit events from WA is not supported");
    }
}

