/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.rest.api.service.ClientAppService;

public class ClientAppRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -1392090291817187902L;
    private static final Comparator<ClientAppTO> COMPARATOR = Comparator.comparing(ClientAppTO::getName);

    public static <T extends ClientAppTO> T read(ClientAppType type, String key) {
        ClientAppTO policy = null;
        try {
            policy = ((ClientAppService)ClientAppRestClient.getService(ClientAppService.class)).read(type, key);
        }
        catch (Exception e) {
            LOG.warn("No client app found for type {} and key {}", new Object[]{type, key, e});
        }
        return (T)policy;
    }

    public static <T extends ClientAppTO> List<T> list(ClientAppType type) {
        try {
            return ((ClientAppService)ClientAppRestClient.getService(ClientAppService.class)).list(type).stream().sorted(COMPARATOR).collect(Collectors.toList());
        }
        catch (Exception ignore) {
            LOG.debug("No client app found", (Throwable)ignore);
            return List.of();
        }
    }

    public static <T extends ClientAppTO> void create(ClientAppType type, T policy) {
        ((ClientAppService)ClientAppRestClient.getService(ClientAppService.class)).create(type, policy);
    }

    public static <T extends ClientAppTO> void update(ClientAppType type, T policy) {
        ((ClientAppService)ClientAppRestClient.getService(ClientAppService.class)).update(type, policy);
    }

    public static void delete(ClientAppType type, String key) {
        ((ClientAppService)ClientAppRestClient.getService(ClientAppService.class)).delete(type, key);
    }
}

