/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.commons.IdRepoRealmPolicyProvider;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.PolicyRenderer;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class AMRealmPolicyProvider
extends IdRepoRealmPolicyProvider {
    private static final long serialVersionUID = 1671878489700L;
    private final IModel<Map<String, String>> accessPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list((PolicyType)PolicyType.ACCESS).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };
    private final IModel<Map<String, String>> attrReleasePolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list((PolicyType)PolicyType.ATTR_RELEASE).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };
    private final IModel<Map<String, String>> authPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list((PolicyType)PolicyType.AUTH).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };

    public void add(RealmTO realmTO, RepeatingView view) {
        super.add(realmTO, view);
        AjaxDropDownChoicePanel accessPolicy = new AjaxDropDownChoicePanel(view.newChildId(), new ResourceModel("accessPolicy", "accessPolicy").getObject(), (IModel)new PropertyModel((Object)realmTO, "accessPolicy"), false);
        accessPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(this.accessPolicies));
        accessPolicy.setChoices(new ArrayList(((Map)this.accessPolicies.getObject()).keySet()));
        ((AbstractSingleSelectChoice)accessPolicy.getField()).setNullValid(true);
        view.add(new Component[]{accessPolicy});
        AjaxDropDownChoicePanel attrReleasePolicy = new AjaxDropDownChoicePanel(view.newChildId(), new ResourceModel("attrReleasePolicy", "attrReleasePolicy").getObject(), (IModel)new PropertyModel((Object)realmTO, "attrReleasePolicy"), false);
        attrReleasePolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(this.attrReleasePolicies));
        attrReleasePolicy.setChoices(new ArrayList(((Map)this.attrReleasePolicies.getObject()).keySet()));
        ((AbstractSingleSelectChoice)attrReleasePolicy.getField()).setNullValid(true);
        view.add(new Component[]{attrReleasePolicy});
        AjaxDropDownChoicePanel authPolicy = new AjaxDropDownChoicePanel(view.newChildId(), new ResourceModel("authPolicy", "authPolicy").getObject(), (IModel)new PropertyModel((Object)realmTO, "authPolicy"), false);
        authPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(this.authPolicies));
        authPolicy.setChoices(new ArrayList(((Map)this.authPolicies.getObject()).keySet()));
        ((AbstractSingleSelectChoice)authPolicy.getField()).setNullValid(true);
        view.add(new Component[]{authPolicy});
    }
}

