/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.clientapps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.ClientAppRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.PolicyRenderer;
import org.apache.syncope.client.ui.commons.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.FieldPanel;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.WizardModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.lib.types.OIDCGrantType;
import org.apache.syncope.common.lib.types.OIDCResponseType;
import org.apache.syncope.common.lib.types.OIDCSubjectType;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.lib.types.SAML2SPNameId;
import org.apache.syncope.common.lib.types.XmlSecAlgorithm;
import org.apache.syncope.common.rest.api.beans.RealmQuery;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.UrlValidator;

public class ClientAppModalPanelBuilder<T extends ClientAppTO>
extends AbstractModalPanelBuilder<T> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final IModel<Map<String, String>> accessPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list((PolicyType)PolicyType.ACCESS).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };
    private final IModel<Map<String, String>> attrReleasePolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list((PolicyType)PolicyType.ATTR_RELEASE).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };
    private final IModel<Map<String, String>> authPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            return PolicyRestClient.list((PolicyType)PolicyType.AUTH).stream().collect(Collectors.toMap(PolicyTO::getKey, PolicyTO::getName));
        }
    };
    private final BaseModal<T> modal;
    private final ClientAppType type;

    public ClientAppModalPanelBuilder(ClientAppType type, T defaultItem, BaseModal<T> modal, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.type = type;
        this.modal = modal;
    }

    public WizardModalPanel<T> build(String id, int index, AjaxWizard.Mode mode) {
        return new Profile(this, (ClientAppTO)this.newModelObject(), this.modal, this.pageRef);
    }

    private static class Profile
    extends AbstractModalPanel<T> {
        private static final long serialVersionUID = 7647959917047450318L;
        private final T clientAppTO;
        final /* synthetic */ ClientAppModalPanelBuilder this$0;

        Profile(T clientAppTO, BaseModal<T> modal, PageReference pageRef) {
            this.this$0 = var1_1;
            super(modal, pageRef);
            modal.setFormModel(clientAppTO);
            this.clientAppTO = clientAppTO;
            ArrayList<Object> fields = new ArrayList<Object>();
            final boolean isSearchEnabled = RealmsUtils.isSearchEnabled();
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(!isSearchEnabled);
            settings.setShowListOnEmptyInput(!isSearchEnabled);
            AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel("field", "realm", (IModel)new PropertyModel(clientAppTO, "realm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                protected Iterator<String> getChoices(String input) {
                    return (isSearchEnabled ? RealmRestClient.search((RealmQuery)RealmsUtils.buildQuery((String)input)).getResult() : RealmRestClient.list((String)"/")).stream().filter(realm -> SyncopeConsoleSession.get().getAuthRealms().stream().anyMatch(authRealm -> realm.getFullPath().startsWith((String)authRealm))).map(RealmTO::getFullPath).collect(Collectors.toList()).iterator();
                }
            };
            fields.add(realm.setOutputMarkupId(true));
            final AjaxTextFieldPanel name = new AjaxTextFieldPanel("field", "name", (IModel)new PropertyModel(clientAppTO, "name"), false);
            fields.add(name.setRequired(true));
            if (clientAppTO.getClientAppId() == null) {
                Stream.of(ClientAppType.values()).map(ClientAppRestClient::list).flatMap(Collection::stream).max(Comparator.comparing(ClientAppTO::getClientAppId)).ifPresent(app -> clientAppTO.setClientAppId(Long.valueOf(app.getClientAppId() + 1L)));
            }
            fields.add(new AjaxSpinnerFieldPanel.Builder().build("field", "clientAppId", Long.class, (IModel)new PropertyModel(clientAppTO, "clientAppId")).setRequired(true));
            fields.add(new AjaxTextFieldPanel("field", "description", (IModel)new PropertyModel(clientAppTO, "description"), false));
            AjaxDropDownChoicePanel accessPolicy = new AjaxDropDownChoicePanel("field", "accessPolicy", (IModel)new PropertyModel(clientAppTO, "accessPolicy"), false);
            accessPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(var1_1.accessPolicies));
            accessPolicy.setChoices(new ArrayList(((Map)var1_1.accessPolicies.getObject()).keySet()));
            ((AbstractSingleSelectChoice)accessPolicy.getField()).setNullValid(true);
            fields.add(accessPolicy);
            AjaxDropDownChoicePanel attrReleasePolicy = new AjaxDropDownChoicePanel("field", "attrReleasePolicy", (IModel)new PropertyModel(clientAppTO, "attrReleasePolicy"), false);
            attrReleasePolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(var1_1.attrReleasePolicies));
            attrReleasePolicy.setChoices(new ArrayList(((Map)var1_1.attrReleasePolicies.getObject()).keySet()));
            ((AbstractSingleSelectChoice)attrReleasePolicy.getField()).setNullValid(true);
            fields.add(attrReleasePolicy);
            AjaxDropDownChoicePanel authPolicy = new AjaxDropDownChoicePanel("field", "authPolicy", (IModel)new PropertyModel(clientAppTO, "authPolicy"), false);
            authPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(var1_1.authPolicies));
            authPolicy.setChoices(new ArrayList(((Map)var1_1.authPolicies.getObject()).keySet()));
            authPolicy.setRequired(true);
            ((AbstractSingleSelectChoice)authPolicy.getField()).setNullValid(true);
            fields.add(authPolicy);
            fields.add(new AjaxTextFieldPanel("field", "theme", (IModel)new PropertyModel(clientAppTO, "theme"), false));
            switch (var1_1.type) {
                case CASSP: {
                    fields.add(new AjaxTextFieldPanel("field", "serviceId", (IModel)new PropertyModel(clientAppTO, "serviceId"), false).setRequired(true));
                    break;
                }
                case OIDCRP: {
                    final AjaxTextFieldPanel clientId = new AjaxTextFieldPanel("field", "clientId", (IModel)new PropertyModel(clientAppTO, "clientId"), false);
                    fields.add(clientId.setRequired(true));
                    name.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                        private static final long serialVersionUID = -6139318907146065915L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            if (StringUtils.isBlank((CharSequence)((CharSequence)((Object)clientId.getModelObject())))) {
                                clientId.setModelObject((Serializable)((Object)((String)((Object)name.getModelObject()))));
                                target.add(new Component[]{clientId});
                            }
                        }
                    }});
                    AjaxTextFieldPanel clientSecret = new AjaxTextFieldPanel("field", "clientSecret", (IModel)new PropertyModel(clientAppTO, "clientSecret"), false);
                    clientSecret.setChoices(List.of(RandomStringUtils.randomAlphanumeric((int)15)));
                    fields.add(clientSecret.setRequired(true));
                    fields.add(new AjaxCheckBoxPanel("field", "signIdToken", (IModel)new PropertyModel(clientAppTO, "signIdToken")));
                    fields.add(new AjaxCheckBoxPanel("field", "jwtAccessToken", (IModel)new PropertyModel(clientAppTO, "jwtAccessToken")));
                    fields.add(new AjaxCheckBoxPanel("field", "bypassApprovalPrompt", (IModel)new PropertyModel(clientAppTO, "bypassApprovalPrompt")));
                    AjaxDropDownChoicePanel subjectType = new AjaxDropDownChoicePanel("field", "subjectType", (IModel)new PropertyModel(clientAppTO, "subjectType"), false);
                    subjectType.setChoices(List.of(OIDCSubjectType.values()));
                    subjectType.addRequiredLabel().setEnabled(true);
                    fields.add(subjectType);
                    AjaxTextFieldPanel redirectUri = new AjaxTextFieldPanel("panel", "redirectUris", (IModel)new Model());
                    redirectUri.addValidator((IValidator)new UrlValidator());
                    fields.add(new MultiFieldPanel.Builder((IModel)new PropertyModel(clientAppTO, "redirectUris")).build("field", "redirectUris", (FieldPanel)redirectUri));
                    fields.add(new AjaxPalettePanel.Builder().setName("supportedGrantTypes").build("field", (IModel)new PropertyModel(clientAppTO, "supportedGrantTypes"), (IModel)new ListModel(List.of(OIDCGrantType.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("supportedResponseTypes").build("field", (IModel)new PropertyModel(clientAppTO, "supportedResponseTypes"), (IModel)new ListModel(List.of(OIDCResponseType.values()))));
                    AjaxTextFieldPanel logoutUri = new AjaxTextFieldPanel("field", "logoutUri", (IModel)new PropertyModel(clientAppTO, "logoutUri"), false);
                    logoutUri.addValidator((IValidator)new UrlValidator());
                    fields.add(logoutUri);
                    break;
                }
                case SAML2SP: {
                    AjaxTextFieldPanel entityId = new AjaxTextFieldPanel("field", "entityId", (IModel)new PropertyModel(clientAppTO, "entityId"), false);
                    entityId.addValidator((IValidator)new UrlValidator());
                    fields.add(entityId.setRequired(true));
                    fields.add(new AjaxTextFieldPanel("field", "metadataLocation", (IModel)new PropertyModel(clientAppTO, "metadataLocation"), false).setRequired(true));
                    fields.add(new AjaxTextFieldPanel("field", "metadataSignatureLocation", (IModel)new PropertyModel(clientAppTO, "metadataSignatureLocation"), false));
                    fields.add(new AjaxCheckBoxPanel("field", "signAssertions", (IModel)new PropertyModel(clientAppTO, "signAssertions")));
                    fields.add(new AjaxCheckBoxPanel("field", "signResponses", (IModel)new PropertyModel(clientAppTO, "signResponses")));
                    fields.add(new AjaxCheckBoxPanel("field", "encryptionOptional", (IModel)new PropertyModel(clientAppTO, "encryptionOptional")));
                    fields.add(new AjaxCheckBoxPanel("field", "encryptAssertions", (IModel)new PropertyModel(clientAppTO, "encryptAssertions")));
                    fields.add(new AjaxTextFieldPanel("field", "requiredAuthenticationContextClass", (IModel)new PropertyModel(clientAppTO, "requiredAuthenticationContextClass"), false));
                    AjaxDropDownChoicePanel requiredNameIdFormat = new AjaxDropDownChoicePanel("field", "requiredNameIdFormat", (IModel)new PropertyModel(clientAppTO, "requiredNameIdFormat"), false);
                    requiredNameIdFormat.setChoices(List.of(SAML2SPNameId.values()));
                    requiredNameIdFormat.addRequiredLabel().setEnabled(true);
                    fields.add(requiredNameIdFormat);
                    fields.add(new AjaxSpinnerFieldPanel.Builder().min((Number)0).build("field", "skewAllowance", Integer.class, (IModel)new PropertyModel(clientAppTO, "skewAllowance")));
                    fields.add(new AjaxTextFieldPanel("field", "nameIdQualifier", (IModel)new PropertyModel(clientAppTO, "nameIdQualifier"), false));
                    AjaxTextFieldPanel assertionAudience = new AjaxTextFieldPanel("panel", "assertionAudience", (IModel)new Model());
                    assertionAudience.addValidator((IValidator)new UrlValidator());
                    fields.add(new MultiFieldPanel.Builder((IModel)new PropertyModel(clientAppTO, "assertionAudiences")).build("field", "assertionAudiences", (FieldPanel)assertionAudience));
                    fields.add(new AjaxTextFieldPanel("field", "serviceProviderNameIdQualifier", (IModel)new PropertyModel(clientAppTO, "serviceProviderNameIdQualifier"), false));
                    fields.add(new AjaxPalettePanel.Builder().setName("signingSignatureAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "signingSignatureAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("signingSignatureReferenceDigestMethods").build("field", (IModel)new PropertyModel(clientAppTO, "signingSignatureReferenceDigestMethods"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("encryptionDataAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "encryptionDataAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("encryptionKeyAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "encryptionKeyAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("signingSignatureBlackListedAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "signingSignatureBlackListedAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    fields.add(new AjaxPalettePanel.Builder().setName("encryptionBlackListedAlgorithms").build("field", (IModel)new PropertyModel(clientAppTO, "encryptionBlackListedAlgorithms"), (IModel)new ListModel(List.of(XmlSecAlgorithm.values()))));
                    break;
                }
            }
            this.add(new Component[]{new ListView<Component>("fields", fields){
                private static final long serialVersionUID = -9180479401817023838L;

                protected void populateItem(ListItem<Component> item) {
                    item.add(new Component[]{(Component)item.getModelObject()});
                }
            }});
        }

        public void onSubmit(AjaxRequestTarget target) {
            try {
                if (this.clientAppTO.getKey() == null) {
                    ClientAppRestClient.create(this.this$0.type, this.clientAppTO);
                } else {
                    ClientAppRestClient.update(this.this$0.type, this.clientAppTO);
                }
                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                this.modal.close((IPartialPageRequestHandler)target);
            }
            catch (Exception e) {
                LOG.error("While creating/updating clientApp", (Throwable)e);
                SyncopeConsoleSession.get().onException(e);
            }
            ((BaseWebPage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }
}

