/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.clientapps;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.clientapps.ClientAppPropertiesDirectoryPanel;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalDirectoryPanel;
import org.apache.syncope.client.console.rest.ClientAppRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public abstract class ClientAppDirectoryPanel<T extends ClientAppTO>
extends DirectoryPanel<T, T, DirectoryDataProvider<T>, ClientAppRestClient> {
    private static final long serialVersionUID = 4100100988730985059L;
    private final ClientAppType type;
    protected final BaseModal<T> propertiesModal;

    public ClientAppDirectoryPanel(String id, ClientAppType type, PageReference pageRef) {
        super(id, pageRef, true);
        this.type = type;
        this.modal.addSubmitButton();
        this.modal.size(Modal.Size.Large);
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.setFooterVisibility(true);
        this.propertiesModal = new BaseModal<T>("outer"){
            private static final long serialVersionUID = 389935548143327858L;

            protected void onConfigure() {
                super.onConfigure();
                this.setFooterVisible(false);
            }
        };
        this.propertiesModal.size(Modal.Size.Large);
        this.propertiesModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> this.propertiesModal.show(false));
        this.addOuterObject(new Component[]{this.propertiesModal});
        this.disableCheckBoxes();
    }

    protected List<IColumn<T, String>> getColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new KeyPropertyColumn((IModel)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("clientAppId", (Component)this), (Object)"clientAppId", "clientAppId"));
        this.addCustomColumnFields(columns);
        return columns;
    }

    protected void addCustomColumnFields(List<IColumn<T, String>> columns) {
    }

    public ActionsPanel<T> getActions(final IModel<T> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppDirectoryPanel.this.send((IEventSink)ClientAppDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent(ClientAppRestClient.read(ClientAppDirectoryPanel.this.type, ((ClientAppTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                model.setObject(ClientAppRestClient.read(ClientAppDirectoryPanel.this.type, ((ClientAppTO)model.getObject()).getKey()));
                target.add(new Component[]{ClientAppDirectoryPanel.this.propertiesModal.setContent((ModalPanel)new ModalDirectoryPanel(ClientAppDirectoryPanel.this.propertiesModal, new ClientAppPropertiesDirectoryPanel("panel", ClientAppDirectoryPanel.this.propertiesModal, ClientAppDirectoryPanel.this.type, model, ClientAppDirectoryPanel.this.pageRef), ClientAppDirectoryPanel.this.pageRef))});
                ClientAppDirectoryPanel.this.propertiesModal.header((IModel)new Model((Serializable)((Object)ClientAppDirectoryPanel.this.getString("properties.title", model))));
                ClientAppDirectoryPanel.this.propertiesModal.show(true);
            }
        }, ActionLink.ActionType.TYPE_EXTENSIONS, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppTO clone = (ClientAppTO)SerializationUtils.clone((Serializable)((ClientAppTO)model.getObject()));
                clone.setKey(null);
                clone.setClientAppId(null);
                ClientAppDirectoryPanel.this.send((IEventSink)ClientAppDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)clone, target));
            }
        }, ActionLink.ActionType.CLONE, "CLIENTAPP_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            public void onClick(AjaxRequestTarget target, ClientAppTO ignore) {
                ClientAppTO clientAppTO = (ClientAppTO)model.getObject();
                try {
                    ClientAppRestClient.delete(ClientAppDirectoryPanel.this.type, clientAppTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ClientAppDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ClientAppDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)clientAppTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)ClientAppDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "CLIENTAPP_DELETE", true);
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    protected ClientAppDataProvider dataProvider() {
        return new ClientAppDataProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "clientapp.paginator.rows";
    }

    protected class ClientAppDataProvider
    extends DirectoryDataProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<T> comparator;

        ClientAppDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator((SortableDataProvider)this);
        }

        public Iterator<T> iterator(long first, long count) {
            List list = ClientAppRestClient.list(ClientAppDirectoryPanel.this.type);
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ClientAppRestClient.list(ClientAppDirectoryPanel.this.type).size();
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }
}

