/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml;

import com.codahale.metrics.MetricRegistry;
import lombok.Generated;
import lombok.NonNull;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.xmlsec.config.DecryptionParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenSamlConfigBean
implements OpenSamlConfigBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOpenSamlConfigBean.class);
    public static final String DEFAULT_BEAN_NAME = "shibboleth.OpenSAMLConfig";
    private final ParserPool parserPool;
    private final XMLObjectBuilderFactory builderFactory;
    private final MarshallerFactory marshallerFactory;
    private final UnmarshallerFactory unmarshallerFactory;
    private final XMLObjectProviderRegistry xmlObjectProviderRegistry;

    public DefaultOpenSamlConfigBean(@NonNull ParserPool parserPool) {
        if (parserPool == null) {
            throw new NullPointerException("parserPool is marked non-null but is null");
        }
        this.parserPool = parserPool;
        FunctionUtils.doUnchecked(u -> {
            LOGGER.trace("Initializing OpenSaml configuration...");
            InitializationService.initialize();
        }, (Object[])new Object[0]);
        this.xmlObjectProviderRegistry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.xmlObjectProviderRegistry.setParserPool(this.parserPool);
        ConfigurationService.register(DecryptionParserPool.class, (Object)new DecryptionParserPool(this.parserPool));
        ConfigurationService.register(MetricRegistry.class, (Object)new MetricRegistry());
        this.builderFactory = this.xmlObjectProviderRegistry.getBuilderFactory();
        this.marshallerFactory = this.xmlObjectProviderRegistry.getMarshallerFactory();
        this.unmarshallerFactory = this.xmlObjectProviderRegistry.getUnmarshallerFactory();
        LOGGER.debug("Initialized OpenSaml successfully.");
    }

    @Override
    public void logObject(XMLObject samlObject) {
        SamlUtils.logSamlObject(this, samlObject);
    }

    @Override
    @Generated
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    @Override
    @Generated
    public XMLObjectBuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    @Override
    @Generated
    public MarshallerFactory getMarshallerFactory() {
        return this.marshallerFactory;
    }

    @Override
    @Generated
    public UnmarshallerFactory getUnmarshallerFactory() {
        return this.unmarshallerFactory;
    }

    @Override
    @Generated
    public XMLObjectProviderRegistry getXmlObjectProviderRegistry() {
        return this.xmlObjectProviderRegistry;
    }
}

