/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class PopulateSpringSecurityContextAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PopulateSpringSecurityContextAction.class);

    protected Event doExecute(RequestContext requestContext) {
        org.apereo.cas.authentication.Authentication authn = WebUtils.getAuthentication((RequestContext)requestContext);
        Principal principal = this.resolvePrincipal(authn.getPrincipal());
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        List authorities = principal.getAttributes().keySet().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        PreAuthenticatedAuthenticationToken secAuth = new PreAuthenticatedAuthenticationToken((Object)principal, (Object)authn.getCredentials(), authorities);
        secAuth.setAuthenticated(true);
        secAuth.setDetails((Object)new PreAuthenticatedGrantedAuthoritiesWebAuthenticationDetails(request, authorities));
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)secAuth);
        HttpSession session = request.getSession(true);
        LOGGER.trace("Storing security context in session [{}] for [{}]", (Object)session.getId(), (Object)principal);
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)context);
        return null;
    }

    protected Principal resolvePrincipal(Principal principal) {
        List resolvers = ApplicationContextProvider.getMultifactorAuthenticationPrincipalResolvers();
        return resolvers.stream().filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElse(principal);
    }
}

