/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.common.keymaster.client.api.DomainWatcher;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DomainDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.DomainEntity;
import org.apache.syncope.core.persistence.api.entity.SelfKeymasterEntityFactory;
import org.springframework.security.access.prepost.PreAuthorize;

public class DomainLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final DomainDAO domainDAO;
    protected final SelfKeymasterEntityFactory entityFactory;
    protected final DomainWatcher domainWatcher;

    public DomainLogic(DomainDAO domainDAO, SelfKeymasterEntityFactory entityFactory, DomainWatcher domainWatcher) {
        this.domainDAO = domainDAO;
        this.entityFactory = entityFactory;
        this.domainWatcher = domainWatcher;
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public List<Domain> list() {
        return this.domainDAO.findAll().stream().map(DomainEntity::get).collect(Collectors.toList());
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public Domain read(String key) {
        DomainEntity domain = this.domainDAO.find(key);
        if (domain == null) {
            throw new NotFoundException("Domain " + key);
        }
        return domain.get();
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public Domain create(Domain domain) {
        if (Objects.equals(domain.getKey(), "Master")) {
            throw new KeymasterException("Cannot create domain Master");
        }
        if (this.domainDAO.find(domain.getKey()) != null) {
            throw new DuplicateException("Domain " + domain.getKey() + " already existing");
        }
        DomainEntity domainEntity = this.entityFactory.newDomainEntity();
        domainEntity.setKey(domain.getKey());
        domainEntity.set(domain);
        domainEntity = this.domainDAO.save(domainEntity);
        this.domainWatcher.added(domain);
        return domainEntity.get();
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public void changeAdminPassword(String key, String password, CipherAlgorithm cipherAlgorithm) {
        DomainEntity domain = this.domainDAO.find(key);
        if (domain == null) {
            throw new NotFoundException("Domain " + key);
        }
        Domain domainObj = domain.get();
        domainObj.setAdminPassword(password);
        domainObj.setAdminCipherAlgorithm(cipherAlgorithm);
        domain.set(domainObj);
        this.domainDAO.save(domain);
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public void adjustPoolSize(String key, int poolMaxActive, int poolMinIdle) {
        DomainEntity domain = this.domainDAO.find(key);
        if (domain == null) {
            throw new NotFoundException("Domain " + key);
        }
        Domain domainObj = domain.get();
        domainObj.setPoolMaxActive(poolMaxActive);
        domainObj.setPoolMinIdle(poolMinIdle);
        domain.set(domainObj);
        this.domainDAO.save(domain);
    }

    @PreAuthorize(value="@environment.getProperty('keymaster.username') == authentication.name and not(isAnonymous())")
    public void delete(String key) {
        this.domainDAO.delete(key);
        this.domainWatcher.removed(key);
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnsupportedOperationException();
    }
}

