/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.io.IOException;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.rest.api.Preference;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchItem;
import org.apache.syncope.common.rest.api.batch.BatchPayloadParser;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.apache.syncope.common.rest.api.service.SyncopeService;
import org.apache.syncope.core.logic.SyncopeLogic;
import org.apache.syncope.core.persistence.api.dao.BatchDAO;
import org.apache.syncope.core.persistence.api.entity.Batch;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.rest.cxf.batch.BatchProcess;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SyncopeServiceImpl
extends AbstractService
implements SyncopeService {
    private static final String CONTENT_XML = "Content.xml";
    protected final SyncopeLogic logic;
    protected final ThreadPoolTaskExecutor batchExecutor;
    protected final Bus bus;
    protected final BatchDAO batchDAO;
    protected final EntityFactory entityFactory;

    public SyncopeServiceImpl(SyncopeLogic logic, ThreadPoolTaskExecutor batchExecutor, Bus bus, BatchDAO batchDAO, EntityFactory entityFactory) {
        this.logic = logic;
        this.batchExecutor = batchExecutor;
        this.bus = bus;
        this.batchDAO = batchDAO;
        this.entityFactory = entityFactory;
    }

    public PagedResult<GroupTO> searchAssignableGroups(String realm, String term, int page, int size) {
        Pair result = this.logic.searchAssignableGroups(StringUtils.prependIfMissing((String)realm, (CharSequence)"/", (CharSequence[])new CharSequence[0]), term, page, size);
        return this.buildPagedResult((List)result.getRight(), page, size, (Integer)result.getLeft());
    }

    public TypeExtensionTO readUserTypeExtension(String groupName) {
        return this.logic.readTypeExtension(groupName);
    }

    private DestinationRegistry getDestinationRegistryFromBusOrDefault() {
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        try {
            HTTPTransportFactory df = (HTTPTransportFactory)dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            return df.getRegistry();
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Could not find CXF's DestinationRegistry", (Throwable)e);
        }
    }

    public Response batch(InputStream input) {
        List batchRequestItems;
        MediaType mediaType = MediaType.valueOf((String)this.messageContext.getHttpServletRequest().getContentType());
        String boundary = (String)mediaType.getParameters().get("boundary");
        if (this.batchDAO.find(boundary) != null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.EntityExists);
            sce.getElements().add("Batch with boundary " + boundary + " already processing");
            throw sce;
        }
        try {
            batchRequestItems = BatchPayloadParser.parse((InputStream)input, (MediaType)mediaType, (BatchItem)new BatchRequestItem());
        }
        catch (IOException e) {
            LOG.error("Could not parse batch request with boundary {}", (Object)boundary, (Object)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
            sce.getElements().add("Batch request with boundary " + boundary);
            throw sce;
        }
        Batch batch = (Batch)this.entityFactory.newEntity(Batch.class);
        batch.setKey(boundary);
        batch.setExpiryTime(OffsetDateTime.now().plusMinutes(5L));
        this.batchDAO.save(batch);
        BatchProcess batchProcess = (BatchProcess)ApplicationContextProvider.getBeanFactory().createBean(BatchProcess.class);
        batchProcess.setBoundary(boundary);
        batchProcess.setBasePath(this.uriInfo.getBaseUri().toASCIIString());
        batchProcess.setBatchRequestItems(batchRequestItems);
        batchProcess.setDestinationRegistry(this.getDestinationRegistryFromBusOrDefault());
        batchProcess.setServletConfig(this.messageContext.getServletConfig());
        batchProcess.setServletRequest(this.messageContext.getHttpServletRequest());
        batchProcess.setAuthentication(SecurityContextHolder.getContext().getAuthentication());
        if (this.getPreference() == Preference.RESPOND_ASYNC) {
            this.batchExecutor.execute((Runnable)batchProcess);
            return Response.accepted().header("Preference-Applied", (Object)this.getPreference().toString()).header("Location", (Object)this.uriInfo.getAbsolutePathBuilder().build(new Object[0])).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
        }
        batchProcess.run();
        return this.batch();
    }

    public Response batch() {
        MediaType mediaType = MediaType.valueOf((String)this.messageContext.getHttpServletRequest().getContentType());
        String boundary = (String)mediaType.getParameters().get("boundary");
        Batch batch = this.batchDAO.find(boundary);
        if (batch == null) {
            throw new NotFoundException("Batch " + boundary);
        }
        if (batch.getResults() == null) {
            return Response.accepted().type(RESTHeaders.multipartMixedWith((String)boundary)).header("Retry-After", (Object)5).header("Location", (Object)this.uriInfo.getAbsolutePathBuilder().build(new Object[0])).build();
        }
        Response response = Response.ok((Object)batch.getResults()).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
        this.batchDAO.delete(boundary);
        return response;
    }

    public Response exportInternalStorageContent() {
        StreamingOutput sout = os -> this.logic.exportInternalStorageContent(os);
        return Response.ok((Object)sout).type("text/xml").header("Content-Disposition", (Object)("attachment; filename=" + AuthContextUtils.getDomain() + CONTENT_XML)).build();
    }
}

