/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.ExecTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.rest.api.RESTHeaders;
import org.apache.syncope.common.rest.api.batch.BatchPayloadGenerator;
import org.apache.syncope.common.rest.api.beans.ExecDeleteQuery;
import org.apache.syncope.common.rest.api.beans.ExecListQuery;
import org.apache.syncope.common.rest.api.beans.ExecSpecs;
import org.apache.syncope.common.rest.api.service.ExecutableService;
import org.apache.syncope.core.logic.AbstractExecutableLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.apache.syncope.core.spring.security.SecureRandomUtils;

public abstract class AbstractExecutableService
extends AbstractService
implements ExecutableService {
    protected abstract AbstractExecutableLogic<?> getExecutableLogic();

    public PagedResult<ExecTO> listExecutions(ExecListQuery query) {
        Pair result = this.getExecutableLogic().listExecutions(query.getKey(), query.getPage().intValue(), query.getSize().intValue(), this.getOrderByClauses(query.getOrderBy()));
        return this.buildPagedResult((List)result.getRight(), query.getPage(), query.getSize(), (Integer)result.getLeft());
    }

    public List<ExecTO> listRecentExecutions(int max) {
        return this.getExecutableLogic().listRecentExecutions(max);
    }

    public void deleteExecution(String executionKey) {
        this.getExecutableLogic().deleteExecution(executionKey);
    }

    public Response deleteExecutions(ExecDeleteQuery query) {
        List batchResponseItems = this.getExecutableLogic().deleteExecutions(query.getKey(), query.getStartedBefore(), query.getStartedAfter(), query.getEndedBefore(), query.getEndedAfter());
        String boundary = "deleteExecutions_" + SecureRandomUtils.generateRandomUUID().toString();
        return Response.ok((Object)BatchPayloadGenerator.generate((List)batchResponseItems, (String)("--" + boundary))).type(RESTHeaders.multipartMixedWith((String)boundary)).build();
    }

    public ExecTO execute(ExecSpecs query) {
        return this.getExecutableLogic().execute(query.getKey(), query.getStartAt(), query.getDryRun().booleanValue());
    }

    public JobTO getJob(String key) {
        return this.getExecutableLogic().getJob(key);
    }

    public List<JobTO> listJobs() {
        return this.getExecutableLogic().listJobs();
    }

    public void actionJob(String key, JobAction action) {
        this.getExecutableLogic().actionJob(key, action);
    }
}

