/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.batch;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.syncope.common.rest.api.batch.BatchRequestItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchItemRequest
extends HttpServletRequestWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(BatchItemRequest.class);
    private final String basePath;
    private final BatchRequestItem batchItem;
    private final ServletInputStream inputStream;

    public BatchItemRequest(String basePath, HttpServletRequest request, final BatchRequestItem batchItem) {
        super(request);
        this.basePath = basePath;
        this.batchItem = batchItem;
        this.inputStream = new ServletInputStream(){
            private final ByteArrayInputStream bais;
            private boolean isFinished;
            private boolean isReady;
            {
                this.bais = new ByteArrayInputStream(batchItem.getContent().getBytes());
                this.isFinished = false;
                this.isReady = true;
            }

            public boolean isFinished() {
                return this.isFinished;
            }

            public boolean isReady() {
                return this.isReady;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                this.isFinished = true;
                this.isReady = false;
                return this.bais.read();
            }
        };
    }

    public String getMethod() {
        return this.batchItem.getMethod();
    }

    public String getServerName() {
        try {
            return super.getServerName();
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
            return Optional.ofNullable(this.getHeader("Host")).map(host -> StringUtils.substringBefore((String)host, (String)":")).orElse(null);
        }
    }

    public int getServerPort() {
        try {
            return super.getServerPort();
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
            return Optional.ofNullable(this.getHeader("Host")).map(host -> NumberUtils.toInt((String)StringUtils.substringAfter((String)host, (String)":"))).orElse(0);
        }
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.basePath).append(this.getRequestURI());
    }

    public String getRequestURI() {
        return this.batchItem.getRequestURI();
    }

    public String getQueryString() {
        return this.batchItem.getQueryString();
    }

    public String getContentType() {
        return this.batchItem.getHeaders().containsKey("Content-Type") ? ((List)this.batchItem.getHeaders().get("Content-Type")).get(0).toString() : "*/*";
    }

    public int getContentLength() {
        int contentLength = 0;
        if (this.batchItem.getHeaders().containsKey("Content-Length")) {
            try {
                contentLength = Integer.valueOf(((List)this.batchItem.getHeaders().get("Content-Length")).get(0).toString());
            }
            catch (NumberFormatException e) {
                LOG.error("Invalid value found for {}: {}", new Object[]{"Content-Length", this.batchItem.getHeaders().get("Content-Length"), e});
            }
        }
        return contentLength;
    }

    public long getContentLengthLong() {
        return this.getContentLength();
    }

    public String getHeader(String name) {
        try {
            return this.batchItem.getHeaders().containsKey(name) ? ((List)this.batchItem.getHeaders().get(name)).get(0).toString() : ("Content-Type".equals(name) || "Accept".equals(name) ? "*/*" : super.getHeader(name));
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
            return null;
        }
    }

    public Enumeration<String> getHeaders(String name) {
        try {
            return this.batchItem.getHeaders().containsKey(name) ? Collections.enumeration(((List)this.batchItem.getHeaders().get(name)).stream().map(Object::toString).collect(Collectors.toList())) : ("Content-Type".equals(name) || "Accept".equals(name) ? Collections.enumeration(List.of("*/*")) : super.getHeaders(name));
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
            return Collections.emptyEnumeration();
        }
    }

    public Enumeration<String> getHeaderNames() {
        try {
            return super.getHeaderNames();
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
            HashSet names = new HashSet(this.batchItem.getHeaders().keySet());
            names.add("Content-Type");
            names.add("Accept");
            return Collections.enumeration(names);
        }
    }

    public Object getAttribute(String name) {
        try {
            return super.getAttribute(name);
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
            return null;
        }
    }

    public void setAttribute(String name, Object o) {
        try {
            super.setAttribute(name, o);
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
        }
    }

    public String getCharacterEncoding() {
        try {
            return super.getCharacterEncoding();
        }
        catch (Exception e) {
            LOG.debug("While delegating to wrapped request", (Throwable)e);
            return StandardCharsets.UTF_8.name();
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }
}

