/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;

public final class JavaDocUtils {
    public static URL[] getJavaDocURLs() {
        URL[] result = null;
        ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
        if (classLoader instanceof URLClassLoader) {
            ArrayList<URL> javaDocURLs = new ArrayList<URL>();
            for (URL url : ((URLClassLoader)classLoader).getURLs()) {
                String filename = StringUtils.substringAfterLast((String)url.toExternalForm(), (String)"/");
                if (!filename.startsWith("syncope-") || !filename.endsWith("-javadoc.jar")) continue;
                javaDocURLs.add(url);
            }
            if (!javaDocURLs.isEmpty()) {
                result = (URL[])javaDocURLs.toArray(URL[]::new);
            }
        }
        return result;
    }

    public static String[] getJavaDocPaths(Environment env) {
        String[] result = null;
        if (env.containsProperty("javadocPaths")) {
            result = Objects.requireNonNull(env.getProperty("javadocPaths")).split(",");
        }
        return result;
    }

    private JavaDocUtils() {
    }
}

