/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.mdui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.http.HttpResponse;
import org.apereo.cas.support.saml.mdui.AbstractMetadataResolverAdapter;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpMethod;

public class DynamicMetadataResolverAdapter
extends AbstractMetadataResolverAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicMetadataResolverAdapter.class);

    public DynamicMetadataResolverAdapter(Map<Resource, MetadataFilterChain> metadataResources) {
        super(metadataResources);
    }

    @Override
    public EntityDescriptor getEntityDescriptorForEntityId(String entityId) {
        this.buildMetadataResolverAggregate(entityId);
        return super.getEntityDescriptorForEntityId(entityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputStream getResourceInputStream(Resource resource, String entityId) throws IOException {
        if (resource instanceof UrlResource && resource.getURL().toExternalForm().toLowerCase().endsWith("/entities/")) {
            HttpResponse response = null;
            try {
                String encodedId = EncodingUtils.urlEncode((String)entityId);
                String url = resource.getURL().toExternalForm().concat(encodedId);
                LOGGER.debug("Locating metadata input stream for [{}] via [{}]", (Object)encodedId, (Object)url);
                HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.GET).url(url).headers(Map.of("Accept", "*/*")).build();
                response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
                    HttpUtils.close((HttpResponse)response);
                    return byteArrayInputStream;
                }
                HttpUtils.close((HttpResponse)response);
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
            finally {
                HttpUtils.close(response);
            }
        }
        return ClosedInputStream.CLOSED_INPUT_STREAM;
    }

    @Generated
    public DynamicMetadataResolverAdapter() {
    }
}

