/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.io.Serializable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.AnyLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.core.workflow.java.AbstractUserWorkflowAdapter;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class DefaultUserWorkflowAdapter
extends AbstractUserWorkflowAdapter {
    protected final ConfParamOps confParamOps;
    protected final ApplicationEventPublisher publisher;

    public DefaultUserWorkflowAdapter(UserDataBinder dataBinder, UserDAO userDAO, EntityFactory entityFactory, ConfParamOps confParamOps, ApplicationEventPublisher publisher) {
        super(dataBinder, userDAO, entityFactory);
        this.confParamOps = confParamOps;
        this.publisher = publisher;
    }

    @Override
    protected UserWorkflowResult<Pair<String, Boolean>> doCreate(UserCR userCR, boolean disablePwdPolicyCheck, Boolean enabled, String creator, String context) {
        boolean propagateEnable;
        String status;
        User user = (User)this.entityFactory.newEntity(User.class);
        this.dataBinder.create(user, userCR);
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        if (enabled == null) {
            status = "created";
            propagateEnable = true;
        } else {
            status = enabled != false ? "active" : "suspended";
            propagateEnable = enabled;
            user.setSuspended(Boolean.valueOf(enabled == false));
        }
        this.metadata((Any<?>)user, creator, context);
        user.setStatus(status);
        user = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.CREATE, (Any)user, AuthContextUtils.getDomain()));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.userDAO.findAllResourceKeys(user.getKey()));
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        user.getLinkedAccounts().forEach(account -> propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        return new UserWorkflowResult((Object)Pair.of((Object)user.getKey(), (Object)propagateEnable), propByRes, propByLinkedAccount, "create");
    }

    @Override
    protected UserWorkflowResult<String> doActivate(User user, String token, String updater, String context) {
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        this.metadata((Any<?>)user, updater, context);
        user.removeToken();
        user.setStatus("active");
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        return new UserWorkflowResult((Object)updated.getKey(), null, null, "activate");
    }

    @Override
    protected UserWorkflowResult<Pair<UserUR, Boolean>> doUpdate(User user, UserUR userUR, String updater, String context) {
        Pair propInfo = this.dataBinder.update(user, userUR);
        this.metadata((Any<?>)user, updater, context);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        return new UserWorkflowResult((Object)Pair.of((Object)userUR, (Object)(user.isSuspended() == false ? 1 : 0)), (PropagationByResource)propInfo.getLeft(), (PropagationByResource)propInfo.getRight(), "update");
    }

    @Override
    protected UserWorkflowResult<String> doSuspend(User user, String updater, String context) {
        this.metadata((Any<?>)user, updater, context);
        user.setStatus("suspended");
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        return new UserWorkflowResult((Object)updated.getKey(), null, null, "suspend");
    }

    @Override
    protected UserWorkflowResult<String> doReactivate(User user, String updater, String context) {
        this.metadata((Any<?>)user, updater, context);
        user.setStatus("active");
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        return new UserWorkflowResult((Object)updated.getKey(), null, null, "reactivate");
    }

    @Override
    protected void doRequestPasswordReset(User user, String updater, String context) {
        user.generateToken(((Integer)this.confParamOps.get(AuthContextUtils.getDomain(), "token.length", (Object)256, Integer.class)).intValue(), ((Integer)this.confParamOps.get(AuthContextUtils.getDomain(), "token.expireTime", (Object)60, Integer.class)).intValue());
        this.metadata((Any<?>)user, updater, context);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
    }

    @Override
    protected UserWorkflowResult<Pair<UserUR, Boolean>> doConfirmPasswordReset(User user, String token, String password, String updater, String context) {
        if (!user.checkToken(token)) {
            throw new WorkflowException((Throwable)new IllegalArgumentException("Wrong token: " + token + " for " + user));
        }
        user.removeToken();
        UserUR userUR = new UserUR();
        userUR.setKey(user.getKey());
        userUR.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().onSyncope(true).resources(this.userDAO.findAllResourceKeys(user.getKey())).value((Object)password)).build());
        return this.doUpdate(user, userUR, updater, context);
    }

    @Override
    protected void doDelete(User user, String eraser, String context) {
        this.userDAO.delete((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Any)user, AuthContextUtils.getDomain()));
    }
}

