/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.GroupUR;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.apache.syncope.core.workflow.java.AbstractWorkflowAdapter;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractGroupWorkflowAdapter
extends AbstractWorkflowAdapter
implements GroupWorkflowAdapter {
    protected final GroupDataBinder dataBinder;
    protected final GroupDAO groupDAO;
    protected final EntityFactory entityFactory;

    public AbstractGroupWorkflowAdapter(GroupDataBinder dataBinder, GroupDAO groupDAO, EntityFactory entityFactory) {
        this.dataBinder = dataBinder;
        this.groupDAO = groupDAO;
        this.entityFactory = entityFactory;
    }

    public String getPrefix() {
        return null;
    }

    protected abstract WorkflowResult<String> doCreate(GroupCR var1, String var2, String var3);

    public WorkflowResult<String> create(GroupCR groupCR, String creator, String context) {
        return this.doCreate(groupCR, creator, context);
    }

    protected abstract WorkflowResult<GroupUR> doUpdate(Group var1, GroupUR var2, String var3, String var4);

    public WorkflowResult<GroupUR> update(GroupUR groupUR, String updater, String context) {
        WorkflowResult<GroupUR> result = this.doUpdate((Group)this.groupDAO.authFind(groupUR.getKey()), groupUR, updater, context);
        this.groupDAO.authFind(groupUR.getKey());
        return result;
    }

    protected abstract void doDelete(Group var1, String var2, String var3);

    public void delete(String groupKey, String eraser, String context) {
        this.doDelete((Group)this.groupDAO.authFind(groupKey), eraser, context);
    }
}

