/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.workflow.java;

import java.util.Collections;
import java.util.HashSet;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.provisioning.api.WorkflowResult;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.java.AbstractWorkflowAdapter;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Throwable.class})
public abstract class AbstractAnyObjectWorkflowAdapter
extends AbstractWorkflowAdapter
implements AnyObjectWorkflowAdapter {
    protected final AnyObjectDataBinder dataBinder;
    protected final AnyObjectDAO anyObjectDAO;
    protected final EntityFactory entityFactory;

    public AbstractAnyObjectWorkflowAdapter(AnyObjectDataBinder dataBinder, AnyObjectDAO anyObjectDAO, EntityFactory entityFactory) {
        this.dataBinder = dataBinder;
        this.anyObjectDAO = anyObjectDAO;
        this.entityFactory = entityFactory;
    }

    public String getPrefix() {
        return null;
    }

    protected abstract WorkflowResult<String> doCreate(AnyObjectCR var1, String var2, String var3);

    public WorkflowResult<String> create(AnyObjectCR anyObjectCR, String creator, String context) {
        return this.doCreate(anyObjectCR, creator, context);
    }

    protected abstract WorkflowResult<AnyObjectUR> doUpdate(AnyObject var1, AnyObjectUR var2, String var3, String var4);

    public WorkflowResult<AnyObjectUR> update(AnyObjectUR anyObjectUR, String updater, String context) {
        WorkflowResult<AnyObjectUR> result = this.doUpdate((AnyObject)this.anyObjectDAO.authFind(anyObjectUR.getKey()), anyObjectUR, updater, context);
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.find(anyObjectUR.getKey());
        HashSet authRealms = new HashSet();
        authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault(AnyEntitlement.READ.getFor(anyObject.getType().getKey()), Collections.emptySet()));
        authRealms.addAll(AuthContextUtils.getAuthorizations().getOrDefault(AnyEntitlement.UPDATE.getFor(anyObject.getType().getKey()), Collections.emptySet()));
        this.anyObjectDAO.securityChecks(authRealms, anyObject.getKey(), anyObject.getRealm().getFullPath(), this.anyObjectDAO.findAllGroupKeys(anyObject));
        return result;
    }

    protected abstract void doDelete(AnyObject var1, String var2, String var3);

    public void delete(String anyObjectKey, String eraser, String context) {
        this.doDelete((AnyObject)this.anyObjectDAO.authFind(anyObjectKey), eraser, context);
    }
}

