/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.util;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.util.ADUtilities;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.spi.AbstractConfiguration;

public class DirSyncUtils {
    private static final Log LOG = Log.getLog(DirSyncUtils.class);

    public static String createDirSyncUFilter(ADConfiguration conf, ADUtilities utils) {
        String isDeleted = String.valueOf(conf.isRetrieveDeletedUser()).toUpperCase();
        StringBuilder filter = new StringBuilder();
        StringBuilder mfilter = new StringBuilder();
        StringBuilder ufilter = new StringBuilder();
        mfilter.append("(objectClass=group)");
        ufilter.append(utils.getMembershipSearchFilter(conf));
        ufilter.insert(0, "(&(objectClass=user)").append(")");
        filter.append("(|").append((CharSequence)ufilter).append((CharSequence)mfilter).append("(&(isDeleted=").append(isDeleted).append(")(objectClass=user)))");
        return filter.toString();
    }

    public static String createDirSyncGFilter(ADConfiguration conf) {
        StringBuilder filter = new StringBuilder();
        if (conf.isRetrieveDeletedGroup()) {
            filter.append("(objectClass=group)");
        } else {
            filter.append("(&(objectClass=group)(! (isDeleted=TRUE)))");
        }
        return filter.toString();
    }

    public static String createLdapUFilter(ADConfiguration conf) {
        String[] memberships = conf.getMemberships();
        String isDeleted = String.valueOf(conf.isRetrieveDeletedUser()).toUpperCase();
        StringBuilder filter = new StringBuilder();
        StringBuilder mfilter = new StringBuilder();
        StringBuilder ufilter = new StringBuilder();
        if (memberships != null && memberships.length > 0) {
            mfilter.append("(&(objectClass=group)(|");
            ufilter.append(conf.isMembershipsInOr() ? "(|" : "(&");
            for (String group : memberships) {
                mfilter.append("(distinguishedName=").append(group).append(")");
                ufilter.append("(").append("memberOf").append("=").append(group).append(")");
            }
            ufilter.append(")");
            mfilter.append("))");
        }
        ufilter.insert(0, "(&(objectClass=user)").append(")");
        filter.append("(|").append((CharSequence)ufilter).append((CharSequence)mfilter).append("(&(isDeleted=").append(isDeleted).append(")(objectClass=user)))");
        return filter.toString();
    }

    public static boolean verifyCustomFilter(LdapContext ctx, String dn, ADConfiguration conf) {
        return DirSyncUtils.verifyFilter(ctx, dn, DirSyncUtils.getFilter((AbstractConfiguration)conf));
    }

    public static String getUserFilter(ADConfiguration conf) {
        StringBuilder filter = new StringBuilder();
        filter.append("(&(").append(DirSyncUtils.createLdapUFilter(conf)).append(")");
        filter.append(DirSyncUtils.getFilter((AbstractConfiguration)conf) != null ? DirSyncUtils.getFilter((AbstractConfiguration)conf) : "").append(")");
        return filter.toString();
    }

    public static boolean verifyFilter(LdapContext ctx, String dn, String filter) {
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(0);
        searchCtls.setReturningAttributes(new String[0]);
        boolean found = true;
        if (StringUtil.isNotBlank((String)filter)) {
            try {
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchCtls);
                found = res != null && res.hasMoreElements();
            }
            catch (NamingException ex) {
                LOG.warn((Throwable)ex, "Error searching for {0}", new Object[]{filter});
                found = false;
            }
        }
        return found;
    }

    private static String getFilter(AbstractConfiguration conf) {
        return ((ADConfiguration)conf).getAccountSearchFilter();
    }
}

