/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.wizards.any.UserFormFinalizer;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ClassUtils;

public final class UserFormFinalizerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UserFormFinalizerUtils.class);
    @Autowired
    private ClassPathScanImplementationLookup lookup;

    public List<UserFormFinalizer> getFormFinalizers(AjaxWizard.Mode mode) {
        ArrayList<UserFormFinalizer> finalizers = new ArrayList<UserFormFinalizer>();
        this.lookup.getUserFormFinalizerClasses(mode).forEach(applier -> {
            if (applier != null) {
                try {
                    finalizers.add((UserFormFinalizer)ClassUtils.getConstructorIfAvailable((Class)applier, (Class[])new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    LOG.error("Could not instantiate {}", applier, (Object)e);
                }
            }
        });
        return finalizers;
    }
}

