/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.List;
import java.util.Optional;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.layout.GroupFormLayoutInfo;
import org.apache.syncope.client.console.wizards.any.Details;
import org.apache.syncope.client.console.wizards.any.GroupWizardBuilder;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.client.console.wizards.any.TemplateWizardBuilder;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.PageReference;

public class GroupTemplateWizardBuilder
extends GroupWizardBuilder
implements TemplateWizardBuilder<GroupTO> {
    private static final long serialVersionUID = 6716803168859873877L;
    private final TemplatableTO templatable;

    public GroupTemplateWizardBuilder(TemplatableTO templatable, List<String> anyTypeClasses, GroupFormLayoutInfo formLayoutInfo, PageReference pageRef) {
        super((GroupTO)null, anyTypeClasses, formLayoutInfo, pageRef);
        this.templatable = templatable;
        if (templatable.getTemplates().containsKey(AnyTypeKind.GROUP.name())) {
            this.setItem(new GroupWrapper((GroupTO)GroupTO.class.cast(templatable.getTemplates().get(AnyTypeKind.GROUP.name()))));
        } else {
            GroupTO groupTO = new GroupTO();
            if (templatable instanceof RealmTO) {
                groupTO.setRealm(String.format("'%s'", RealmsUtils.getFullPath(((RealmTO)RealmTO.class.cast(templatable)).getFullPath())));
            }
            this.setItem(new GroupWrapper(groupTO));
        }
    }

    @Override
    protected Optional<Details<GroupTO>> addOptionalDetailsPanel(AnyWrapper<GroupTO> modelObject) {
        Optional<Details<GroupTO>> details = super.addOptionalDetailsPanel(modelObject);
        if (this.templatable instanceof RealmTO && details.isPresent()) {
            details.get().disableRealmSpecification();
        }
        return details;
    }

    @Override
    public AjaxWizard<AnyWrapper<GroupTO>> build(String id) {
        return super.build(id, AjaxWizard.Mode.TEMPLATE);
    }
}

