/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import java.io.Serializable;
import java.util.Map;
import org.apache.syncope.client.console.chartjs.Chart;
import org.apache.syncope.client.console.chartjs.ChartJSPanel;
import org.apache.syncope.client.console.chartjs.Doughnut;
import org.apache.syncope.client.console.chartjs.DoughnutChartData;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class UsersByStatusWidget
extends BaseWidget {
    private static final long serialVersionUID = -816175678514035085L;
    private static final String[] COLORS = new String[]{"green", "orange", "aqua", "red", "gray"};
    private Map<String, Integer> usersByStatus;
    private final ChartJSPanel chart;

    public UsersByStatusWidget(String id, Map<String, Integer> usersByStatus) {
        super(id);
        this.usersByStatus = usersByStatus;
        this.setOutputMarkupId(true);
        this.chart = new ChartJSPanel("chart", (IModel<? extends Chart<?>>)Model.of((Serializable)UsersByStatusWidget.build(usersByStatus)));
        this.add(new Component[]{this.chart});
    }

    private static Doughnut build(Map<String, Integer> usersByStatus) {
        Doughnut doughnut = new Doughnut();
        doughnut.getOptions().setResponsive(true);
        doughnut.getOptions().setMaintainAspectRatio(true);
        int i = 0;
        for (Map.Entry<String, Integer> entry : usersByStatus.entrySet()) {
            doughnut.getData().add(new DoughnutChartData(entry.getValue(), COLORS[i % 5], entry.getKey()));
            ++i;
        }
        return doughnut;
    }

    public boolean refresh(Map<String, Integer> usersByStatus) {
        if (!this.usersByStatus.equals(usersByStatus)) {
            this.usersByStatus = usersByStatus;
            this.chart.setDefaultModelObject(UsersByStatusWidget.build(usersByStatus));
            return true;
        }
        return false;
    }
}

