/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.TaskDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.TaskDirectoryPanel;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.PropagationTaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public abstract class PropagationTaskDirectoryPanel
extends TaskDirectoryPanel<PropagationTaskTO>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    private final String resource;

    protected PropagationTaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, String resource, PageReference pageRef) {
        super(baseModal, multiLevelPanelRef, pageRef, false);
        this.resource = resource;
        this.initResultTable();
    }

    @Override
    protected List<IColumn<PropagationTaskTO, String>> getColumns() {
        ArrayList<IColumn<PropagationTaskTO, String>> columns = new ArrayList<IColumn<PropagationTaskTO, String>>();
        columns.add((IColumn<PropagationTaskTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<PropagationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("operation", (Component)this), (Object)"operation", "operation"));
        if (this.resource == null) {
            columns.add((IColumn<PropagationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("resource", (Component)this), (Object)"resource", "resource"));
        } else {
            columns.add((IColumn<PropagationTaskTO, String>)new PropertyColumn<PropagationTaskTO, String>((IModel)new StringResourceModel("anyTypeKind", (Component)this), "anyTypeKind", "anyTypeKind"){
                private static final long serialVersionUID = 3344577098912281394L;

                public IModel<?> getDataModel(IModel<PropagationTaskTO> rowModel) {
                    if (((PropagationTaskTO)rowModel.getObject()).getAnyTypeKind() == null) {
                        return Model.of((Serializable)((Object)"REALM"));
                    }
                    return super.getDataModel(rowModel);
                }
            });
        }
        columns.add((IColumn<PropagationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("entityKey", (Component)this), (Object)"entityKey", "entityKey"));
        columns.add((IColumn<PropagationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("connObjectKey", (Component)this), (Object)"connObjectKey", "connObjectKey"));
        columns.add((IColumn<PropagationTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("start", (Component)this), "start", "start"));
        columns.add((IColumn<PropagationTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("end", (Component)this), "end", "end"));
        columns.add((IColumn<PropagationTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this), (Object)"latestExecStatus", "latestExecStatus"));
        return columns;
    }

    @Override
    public ActionsPanel<PropagationTaskTO> getActions(IModel<PropagationTaskTO> model) {
        ActionsPanel<PropagationTaskTO> panel = super.getActions(model);
        final PropagationTaskTO taskTO = (PropagationTaskTO)model.getObject();
        panel.add(new ActionLink<PropagationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PropagationTaskTO modelObject) {
                PropagationTaskDirectoryPanel.this.getTogglePanel().close(target);
                PropagationTaskDirectoryPanel.this.viewTaskExecs(taskTO, target);
            }
        }, ActionLink.ActionType.VIEW_EXECUTIONS, "TASK_READ");
        panel.add(new ActionLink<PropagationTaskTO>(){
            private static final long serialVersionUID = 9206257220553949594L;

            @Override
            public void onClick(AjaxRequestTarget target, PropagationTaskTO modelObject) {
                PropagationTaskDirectoryPanel.this.getTogglePanel().close(target);
                PropagationTaskDirectoryPanel.this.viewTaskDetails(modelObject, target);
            }
        }, ActionLink.ActionType.VIEW_DETAILS, "TASK_READ");
        panel.add(new ActionLink<PropagationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PropagationTaskTO modelObject) {
                try {
                    ((TaskRestClient)PropagationTaskDirectoryPanel.this.restClient).startExecution(taskTO.getKey(), null);
                    SyncopeConsoleSession.get().success((Serializable)((Object)PropagationTaskDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{PropagationTaskDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While running {}", (Object)taskTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)PropagationTaskDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.EXECUTE, "TASK_EXECUTE");
        panel.add(new ActionLink<PropagationTaskTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PropagationTaskTO modelObject) {
                try {
                    TaskRestClient.delete(TaskType.PROPAGATION, taskTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)PropagationTaskDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{PropagationTaskDirectoryPanel.this.container});
                    PropagationTaskDirectoryPanel.this.getTogglePanel().close(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)taskTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)PropagationTaskDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "TASK_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.DELETE);
        batches.add(ActionLink.ActionType.EXECUTE);
        return batches;
    }

    @Override
    protected PropagationTasksProvider dataProvider() {
        return new PropagationTasksProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "proagationtasks.paginator.rows";
    }

    protected abstract void viewTaskDetails(PropagationTaskTO var1, AjaxRequestTarget var2);

    protected class PropagationTasksProvider
    extends TaskDataProvider<PropagationTaskTO> {
        private static final long serialVersionUID = 4725679400450513556L;

        public PropagationTasksProvider(int paginatorRows) {
            super(paginatorRows, TaskType.PROPAGATION);
        }

        public long size() {
            return TaskRestClient.count(PropagationTaskDirectoryPanel.this.resource, TaskType.PROPAGATION);
        }

        public Iterator<PropagationTaskTO> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return TaskRestClient.listPropagationTasks(PropagationTaskDirectoryPanel.this.resource, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }
    }
}

