/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.any.StatusPanel;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.PasswordPanel;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class ChangePasswordModal
extends AbstractModalPanel<AnyWrapper<UserTO>> {
    private static final long serialVersionUID = 6257389301592059194L;
    private final UserRestClient userRestClient = new UserRestClient();
    private final IModel<List<StatusBean>> statusModel;
    private final UserWrapper wrapper;

    public ChangePasswordModal(BaseModal<AnyWrapper<UserTO>> baseModal, PageReference pageReference, UserWrapper wrapper) {
        super(baseModal, pageReference);
        this.wrapper = wrapper;
        PasswordPanel passwordPanel = new PasswordPanel("passwordPanel", wrapper, Boolean.valueOf(false), false);
        passwordPanel.setOutputMarkupId(true);
        this.add(new Component[]{passwordPanel});
        this.statusModel = new ListModel(new ArrayList());
        StatusPanel statusPanel = new StatusPanel("status", (UserTO)wrapper.getInnerObject(), this.statusModel, pageReference);
        statusPanel.setCheckAvailability(ListViewPanel.CheckAvailability.AVAILABLE);
        this.add(new Component[]{statusPanel.setRenderBodyOnly(true)});
    }

    @Override
    public void onSubmit(AjaxRequestTarget target) {
        UserTO inner = (UserTO)this.wrapper.getInnerObject();
        try {
            if (StringUtils.isBlank((CharSequence)inner.getPassword()) || ((List)this.statusModel.getObject()).isEmpty()) {
                SyncopeConsoleSession.get().error((Serializable)((Object)this.getString("operation_error")));
            } else {
                ArrayList<String> resources = new ArrayList<String>();
                boolean isOnSyncope = false;
                for (StatusBean sb : (List)this.statusModel.getObject()) {
                    if (sb.getResource().equals("syncope")) {
                        isOnSyncope = true;
                        continue;
                    }
                    resources.add(sb.getResource());
                }
                UserUR req = (UserUR)new UserUR.Builder(inner.getKey()).password((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)inner.getPassword())).onSyncope(isOnSyncope).resources(resources).build()).build();
                this.userRestClient.update(inner.getETagValue(), req);
                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                this.modal.show(false);
                this.modal.close((IPartialPageRequestHandler)target);
            }
        }
        catch (Exception e) {
            LOG.error("While updating password for user {}", (Object)inner, (Object)e);
            SyncopeConsoleSession.get().onException(e);
        }
        super.onSubmit(target);
    }
}

