/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.audit.AuditEntry;
import org.apache.syncope.common.lib.audit.EventCategory;
import org.apache.syncope.common.lib.to.AuditConfTO;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.rest.api.beans.AuditQuery;
import org.apache.syncope.common.rest.api.service.AuditService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public class AuditRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 4579786978763032240L;

    public static List<AuditLoggerName> list() {
        return AuditRestClient.getService(AuditService.class).list().stream().map(a -> {
            try {
                return AuditLoggerName.fromAuditKey((String)a.getKey());
            }
            catch (Exception e) {
                LOG.error("Unexpected when parsing {}", (Object)a.getKey(), (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Map<String, Set<AuditLoggerName>> listAuditsByCategory() {
        HashMap<String, Set<AuditLoggerName>> result = new HashMap<String, Set<AuditLoggerName>>();
        AuditRestClient.list().forEach(audit -> {
            if (!result.containsKey(audit.getCategory())) {
                result.put(audit.getCategory(), new HashSet());
            }
            ((Set)result.get(audit.getCategory())).add(audit);
        });
        return result;
    }

    public static void enableAudit(AuditLoggerName auditLoggerName) {
        AuditConfTO audit = new AuditConfTO();
        audit.setKey(auditLoggerName.toAuditKey());
        audit.setActive(true);
        AuditRestClient.getService(AuditService.class).set(audit);
    }

    public static void disableAudit(AuditLoggerName auditLoggerName) {
        AuditConfTO audit = new AuditConfTO();
        audit.setKey(auditLoggerName.toAuditKey());
        audit.setActive(false);
        AuditRestClient.getService(AuditService.class).set(audit);
    }

    public static List<EventCategory> listEvents() {
        try {
            return AuditRestClient.getService(AuditService.class).events();
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public List<AuditEntry> search(String key, int page, int size, AuditElements.EventCategoryType type, String category, List<String> events, AuditElements.Result result, SortParam<String> sort) {
        AuditQuery query = (AuditQuery)((AuditQuery.Builder)((AuditQuery.Builder)((AuditQuery.Builder)new AuditQuery.Builder().entityKey(key).size(Integer.valueOf(size))).page(Integer.valueOf(page))).type(type).category(category).events(events).result(result).orderBy(AuditRestClient.toOrderBy(sort))).build();
        return AuditRestClient.getService(AuditService.class).search(query).getResult();
    }

    public int count(String key, AuditElements.EventCategoryType type, String category, List<String> events, AuditElements.Result result) {
        AuditQuery query = (AuditQuery)((AuditQuery.Builder)((AuditQuery.Builder)new AuditQuery.Builder().entityKey(key).page(Integer.valueOf(1))).size(Integer.valueOf(0))).type(type).category(category).events(events).result(result).build();
        return AuditRestClient.getService(AuditService.class).search(query).getTotalCount();
    }
}

