/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.tasks.CrontabPanel;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public class ReportWizardBuilder
extends BaseAjaxWizardBuilder<ReportTO> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final ReportRestClient restClient = new ReportRestClient();
    private CrontabPanel crontabPanel;

    public ReportWizardBuilder(ReportTO reportTO, PageReference pageRef) {
        super(reportTO, pageRef);
    }

    protected Serializable onApplyInternal(ReportTO modelObject) {
        modelObject.setCronExpression(this.crontabPanel.getCronExpression());
        if (modelObject.getKey() == null) {
            ReportRestClient.create(modelObject);
        } else {
            ReportRestClient.update(modelObject);
        }
        return modelObject;
    }

    protected WizardModel buildModelSteps(ReportTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Schedule(modelObject));
        return wizardModel;
    }

    public class Schedule
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Schedule(ReportTO reportTO) {
            ReportWizardBuilder.this.crontabPanel = new CrontabPanel("schedule", (PropertyModel<String>)new PropertyModel((Object)reportTO, "cronExpression"), reportTO.getCronExpression());
            this.add(new Component[]{ReportWizardBuilder.this.crontabPanel});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        public Profile(ReportTO reportTO) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel)new PropertyModel((Object)reportTO, "name"), false);
            name.addRequiredLabel();
            name.setEnabled(true);
            this.add(new Component[]{name});
            AjaxDropDownChoicePanel template = new AjaxDropDownChoicePanel("template", this.getString("template"), (IModel)new PropertyModel((Object)reportTO, "template"));
            template.setChoices(ReportWizardBuilder.this.restClient.listTemplates().stream().map(ReportTemplateTO::getKey).collect(Collectors.toList()));
            template.addRequiredLabel();
            this.add(new Component[]{template});
            AjaxCheckBoxPanel active = new AjaxCheckBoxPanel("active", "active", (IModel)new PropertyModel((Object)reportTO, "active"), false);
            this.add(new Component[]{active});
        }
    }
}

