/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.CollectionPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.ui.commons.DirectoryDataProvider;
import org.apache.syncope.client.ui.commons.pages.BaseWebPage;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public abstract class PolicyDirectoryPanel<T extends PolicyTO>
extends DirectoryPanel<T, T, DirectoryDataProvider<T>, PolicyRestClient> {
    private static final long serialVersionUID = 4984337552918213290L;
    protected final BaseModal<T> ruleCompositionModal = new BaseModal<T>("outer"){
        private static final long serialVersionUID = 389935548143327858L;

        protected void onConfigure() {
            super.onConfigure();
            this.setFooterVisible(false);
        }
    };
    protected final BaseModal<T> policySpecModal = new BaseModal("outer");
    protected final PolicyType type;

    public PolicyDirectoryPanel(String id, PolicyType type, PageReference pageRef) {
        super(id, pageRef, true);
        this.type = type;
        this.restClient = new PolicyRestClient();
        this.ruleCompositionModal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.ruleCompositionModal);
        this.addOuterObject(new Component[]{this.ruleCompositionModal});
        this.policySpecModal.size(Modal.Size.Large);
        this.policySpecModal.addSubmitButton();
        this.setWindowClosedReloadCallback(this.policySpecModal);
        this.addOuterObject(new Component[]{this.policySpecModal});
        this.modal.addSubmitButton();
        this.modal.size(Modal.Size.Large);
        this.modal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
        this.setFooterVisibility(true);
        this.disableCheckBoxes();
    }

    @Override
    protected List<IColumn<T, String>> getColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        if (this.type != PolicyType.ACCESS && this.type != PolicyType.ATTR_RELEASE && this.type != PolicyType.AUTH) {
            columns.add((IColumn<T, String>)new CollectionPropertyColumn((IModel<String>)new StringResourceModel("usedByResources", (Component)this), "usedByResources"));
        }
        if (this.type != PolicyType.PULL && this.type != PolicyType.PUSH) {
            columns.add((IColumn<T, String>)new CollectionPropertyColumn((IModel<String>)new StringResourceModel("usedByRealms", (Component)this), "usedByRealms"));
        }
        this.addCustomColumnFields(columns);
        return columns;
    }

    @Override
    public ActionsPanel<T> getActions(final IModel<T> model) {
        ActionsPanel<T> panel = super.getActions(model);
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyTO ignore) {
                PolicyDirectoryPanel.this.send((IEventSink)PolicyDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent(PolicyRestClient.read(PolicyDirectoryPanel.this.type, ((PolicyTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "POLICY_UPDATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyTO ignore) {
                PolicyTO clone = (PolicyTO)SerializationUtils.clone((Serializable)((PolicyTO)model.getObject()));
                clone.setKey(null);
                PolicyDirectoryPanel.this.send((IEventSink)PolicyDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)clone, target));
            }
        }, ActionLink.ActionType.CLONE, "POLICY_CREATE");
        this.addCustomActions(panel, model);
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyTO ignore) {
                PolicyTO policyTO = (PolicyTO)model.getObject();
                try {
                    PolicyRestClient.delete(PolicyDirectoryPanel.this.type, policyTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)PolicyDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{PolicyDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)policyTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BaseWebPage)PolicyDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "POLICY_DELETE", true);
        return panel;
    }

    protected void addCustomColumnFields(List<IColumn<T, String>> columns) {
    }

    protected void addCustomActions(ActionsPanel<T> panel, IModel<T> model) {
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return List.of();
    }

    @Override
    protected PolicyDataProvider dataProvider() {
        return new PolicyDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "policy.paginator.rows";
    }

    protected class PolicyDataProvider
    extends DirectoryDataProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<T> comparator;

        public PolicyDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator(this);
        }

        public Iterator<T> iterator(long first, long count) {
            List list = PolicyRestClient.list(PolicyDirectoryPanel.this.type);
            list.sort(this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return PolicyRestClient.list(PolicyDirectoryPanel.this.type).size();
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }
}

