/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.notifications.NotificationTasks;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AnyDirectoryPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.UserDisplayAttributesModalPanel;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.status.ChangePasswordModal;
import org.apache.syncope.client.console.tasks.AnyPropagationTasks;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.client.ui.commons.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.rest.api.service.UserSelfService;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class UserDirectoryPanel
extends AnyDirectoryPanel<UserTO, UserRestClient> {
    private static final long serialVersionUID = -1100228004207271270L;

    protected UserDirectoryPanel(String id, Builder builder) {
        this(id, builder, true);
    }

    protected UserDirectoryPanel(String id, Builder builder, boolean wizardInModal) {
        super(id, builder, wizardInModal);
        this.altDefaultModal.setWindowClosedCallback((BaseModal.WindowClosedCallback & Serializable)target -> {
            this.updateResultTable(target);
            this.modal.show(false);
        });
    }

    @Override
    protected String paginatorRowsKey() {
        return "users.paginator.rows";
    }

    @Override
    protected String[] getDefaultAttributeSelection() {
        return UserDisplayAttributesModalPanel.DEFAULT_SELECTION;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.MUSTCHANGEPASSWORD);
        batches.add(ActionLink.ActionType.DELETE);
        batches.add(ActionLink.ActionType.SUSPEND);
        batches.add(ActionLink.ActionType.REACTIVATE);
        return batches;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = super.getHeader(componentId);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{UserDirectoryPanel.this.displayAttributeModal.setContent((ModalPanel)new UserDisplayAttributesModalPanel(UserDirectoryPanel.this.displayAttributeModal, UserDirectoryPanel.this.page.getPageReference(), UserDirectoryPanel.this.plainSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList()), UserDirectoryPanel.this.derSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList())))});
                UserDirectoryPanel.this.displayAttributeModal.header((IModel)new ResourceModel("any.attr.display"));
                UserDirectoryPanel.this.displayAttributeModal.addSubmitButton();
                UserDirectoryPanel.this.displayAttributeModal.show(true);
            }

            @Override
            protected boolean statusCondition(Serializable modelObject) {
                return UserDirectoryPanel.this.wizardInModal;
            }
        }, ActionLink.ActionType.CHANGE_VIEW, "USER_READ").hideLabel();
        return panel;
    }

    @Override
    public ActionsPanel<UserTO> getActions(final IModel<UserTO> model) {
        ActionsPanel<UserTO> panel = super.getActions(model);
        panel.add(new ActionLink<UserTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, UserTO ignore) {
                UserDirectoryPanel.this.send((IEventSink)UserDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)new UserWrapper((UserTO)new UserRestClient().read(((UserTO)model.getObject()).getKey())), target));
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", "USER_READ", "USER_UPDATE")).setRealms(this.realm, ((UserTO)model.getObject()).getDynRealms());
        panel.add(new ActionLink<UserTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, UserTO ignore) {
                try {
                    model.setObject((Object)((UserTO)((UserRestClient)UserDirectoryPanel.this.restClient).read(((UserTO)model.getObject()).getKey())));
                    ((UserRestClient)UserDirectoryPanel.this.restClient).mustChangePassword(((UserTO)model.getObject()).getETagValue(), !((UserTO)model.getObject()).isMustChangePassword(), ((UserTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)UserDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{UserDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While actioning object {}", (Object)((UserTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)UserDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.MUSTCHANGEPASSWORD, "USER_UPDATE").setRealms(this.realm, ((UserTO)model.getObject()).getDynRealms());
        if (this.wizardInModal) {
            panel.add(new ActionLink<UserTO>(){
                private static final long serialVersionUID = -4875218360625971340L;

                @Override
                public void onClick(AjaxRequestTarget target, UserTO ignore) {
                    model.setObject((Object)((UserTO)((UserRestClient)UserDirectoryPanel.this.restClient).read(((UserTO)model.getObject()).getKey())));
                    CompoundPropertyModel formModel = new CompoundPropertyModel((Object)new AnyWrapper((AnyTO)((UserTO)model.getObject())));
                    UserDirectoryPanel.this.displayAttributeModal.setFormModel(formModel);
                    target.add(new Component[]{UserDirectoryPanel.this.displayAttributeModal.setContent((ModalPanel)new ChangePasswordModal(UserDirectoryPanel.this.displayAttributeModal, UserDirectoryPanel.this.pageRef, new UserWrapper((UserTO)model.getObject())))});
                    UserDirectoryPanel.this.displayAttributeModal.header((IModel)new Model((Serializable)((Object)UserDirectoryPanel.this.getString("any.edit", (IModel)new Model((Serializable)new AnyWrapper((AnyTO)((UserTO)model.getObject())))))));
                    UserDirectoryPanel.this.displayAttributeModal.size(Modal.Size.Large);
                    UserDirectoryPanel.this.displayAttributeModal.show(true);
                }
            }, ActionLink.ActionType.PASSWORD_MANAGEMENT, "USER_UPDATE").setRealms(this.realm, ((UserTO)model.getObject()).getDynRealms());
            PlatformInfo platformInfo = SyncopeConsoleSession.get().getAnonymousClient().platform();
            if (platformInfo.isPwdResetAllowed() && !platformInfo.isPwdResetRequiringSecurityQuestions()) {
                panel.add(new ActionLink<UserTO>(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target, UserTO ignore) {
                        try {
                            ((UserSelfService)SyncopeConsoleSession.get().getAnonymousClient().getService(UserSelfService.class)).requestPasswordReset(((UserTO)model.getObject()).getUsername(), null);
                            SyncopeConsoleSession.get().success((Serializable)((Object)UserDirectoryPanel.this.getString("operation_succeeded")));
                            target.add(new Component[]{UserDirectoryPanel.this.container});
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While actioning object {}", (Object)((UserTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)UserDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                }, ActionLink.ActionType.REQUEST_PASSWORD_RESET, "USER_UPDATE").setRealms(this.realm, ((UserTO)model.getObject()).getDynRealms());
            }
            SyncopeWebApplication.get().getAnyDirectoryPanelAdditionalActionLinksProvider().get(model, this.realm, this.altDefaultModal, this.getString("any.edit", (IModel)new Model((Serializable)new AnyWrapper((AnyTO)((UserTO)model.getObject())))), this, this.pageRef).forEach(panel::add);
            panel.add(new ActionLink<UserTO>(){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, UserTO ignore) {
                    target.add(new Component[]{UserDirectoryPanel.this.utilityModal.setContent(new AnyPropagationTasks(UserDirectoryPanel.this.utilityModal, AnyTypeKind.USER, ((UserTO)model.getObject()).getKey(), UserDirectoryPanel.this.pageRef))});
                    UserDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.propagation.tasks", model));
                    UserDirectoryPanel.this.utilityModal.show(true);
                }
            }, ActionLink.ActionType.PROPAGATION_TASKS, "TASK_LIST");
            panel.add(new ActionLink<UserTO>(){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, UserTO ignore) {
                    target.add(new Component[]{UserDirectoryPanel.this.utilityModal.setContent(new NotificationTasks(AnyTypeKind.USER, ((UserTO)model.getObject()).getKey(), UserDirectoryPanel.this.pageRef))});
                    UserDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.notification.tasks", model));
                    UserDirectoryPanel.this.utilityModal.show(true);
                    target.add(new Component[]{UserDirectoryPanel.this.utilityModal});
                }
            }, ActionLink.ActionType.NOTIFICATION_TASKS, "TASK_LIST");
        }
        if (this.wizardInModal) {
            panel.add(new ActionLink<UserTO>(){
                private static final long serialVersionUID = -1978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, UserTO ignore) {
                    model.setObject((Object)((UserTO)((UserRestClient)UserDirectoryPanel.this.restClient).read(((UserTO)model.getObject()).getKey())));
                    target.add(new Component[]{UserDirectoryPanel.this.altDefaultModal.setContent(new AuditHistoryModal<UserTO>(null, null, (UserTO)model.getObject(), "USER_UPDATE"){
                        private static final long serialVersionUID = 959378158400669867L;

                        @Override
                        protected void restore(String json, AjaxRequestTarget target) {
                            UserTO original = (UserTO)model.getObject();
                            try {
                                UserTO updated = (UserTO)DirectoryPanel.MAPPER.readValue(json, UserTO.class);
                                UserUR updateReq = AnyOperations.diff((UserTO)updated, (UserTO)original, (boolean)false);
                                updateReq.setPassword(null);
                                updateReq.setSecurityAnswer(null);
                                ProvisioningResult<UserTO> result = ((UserRestClient)UserDirectoryPanel.this.restClient).update(original.getETagValue(), updateReq);
                                ((UserTO)model.getObject()).setLastChangeDate(((UserTO)result.getEntity()).getLastChangeDate());
                                SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                                target.add(new Component[]{UserDirectoryPanel.this.container});
                            }
                            catch (Exception e) {
                                DirectoryPanel.LOG.error("While restoring user {}", (Object)((UserTO)model.getObject()).getKey(), (Object)e);
                                SyncopeConsoleSession.get().onException(e);
                            }
                            ((BasePage)UserDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                        }
                    })});
                    UserDirectoryPanel.this.altDefaultModal.header((IModel)new Model((Serializable)((Object)UserDirectoryPanel.this.getString("auditHistory.title", (IModel)new Model((Serializable)new AnyWrapper((AnyTO)((UserTO)model.getObject())))))));
                    UserDirectoryPanel.this.altDefaultModal.show(true);
                }
            }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "USER_READ", "AUDIT_LIST")).setRealms(this.realm, ((UserTO)model.getObject()).getDynRealms());
        }
        panel.add(new ActionLink<UserTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, UserTO ignore) {
                UserTO clone = (UserTO)SerializationUtils.clone((Serializable)((UserTO)model.getObject()));
                clone.setKey(null);
                clone.setUsername(((UserTO)model.getObject()).getUsername() + "_clone");
                UserDirectoryPanel.this.send((IEventSink)UserDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent((Serializable)new UserWrapper(clone), target));
            }

            @Override
            protected boolean statusCondition(UserTO modelObject) {
                return UserDirectoryPanel.this.addAjaxLink.isVisibleInHierarchy() && UserDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.CLONE, "USER_CREATE").setRealm(this.realm);
        panel.add(new ActionLink<UserTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, UserTO ignore) {
                try {
                    ((UserRestClient)UserDirectoryPanel.this.restClient).delete(((UserTO)model.getObject()).getETagValue(), ((UserTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)UserDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{UserDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting user {}", (Object)((UserTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)UserDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            @Override
            protected boolean statusCondition(UserTO modelObject) {
                return UserDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.DELETE, "USER_DELETE", true).setRealm(this.realm);
        return panel;
    }

    public static class Builder
    extends AnyDirectoryPanel.Builder<UserTO, UserRestClient> {
        private static final long serialVersionUID = -6603152478702381900L;

        public Builder(List<AnyTypeClassTO> anyTypeClassTOs, String type, PageReference pageRef) {
            super(anyTypeClassTOs, new UserRestClient(), type, pageRef);
            this.setShowResultPage(true);
        }

        @Override
        protected WizardMgtPanel<AnyWrapper<UserTO>> newInstance(String id, boolean wizardInModal) {
            return new UserDirectoryPanel(id, this, wizardInModal);
        }
    }
}

