/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.panels.ConfParam;
import org.apache.syncope.client.console.panels.ToggleableTarget;
import org.apache.syncope.client.console.policies.PolicyRuleWrapper;
import org.apache.syncope.client.console.reports.ReportletWrapper;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.ui.commons.status.StatusBean;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TogglePanel<T extends Serializable>
extends WizardMgtPanel<T> {
    private static final long serialVersionUID = -2025535531121434056L;
    protected static final Logger LOG = LoggerFactory.getLogger(TogglePanel.class);
    protected static final int HEADER_FIRST_ABBREVIATION = 25;
    private static final String LABEL_DATA_VALUE = "data-value";
    private final WebMarkupContainer container;
    private Status status = Status.INACTIVE;
    private final Label header;
    private final String activeId;

    public TogglePanel(String id, PageReference pageRef) {
        this(id, id, pageRef);
    }

    public TogglePanel(String id, String markupId, PageReference pageRef) {
        super(id, true);
        this.activeId = markupId;
        String containerID = StringUtils.isBlank((CharSequence)markupId) ? id : markupId;
        this.setRenderBodyOnly(true);
        this.setOutputMarkupId(true);
        this.disableContainerAutoRefresh();
        this.setPageRef(pageRef);
        this.container = new WebMarkupContainer("togglePanelContainer");
        super.addInnerObject(this.container.setMarkupId(containerID));
        this.header = new Label("label", (Serializable)((Object)""));
        this.header.add(new Behavior[]{new AttributeModifier("title", (IModel)new ResourceModel("copy_to_clipboard.title"))});
        this.header.setOutputMarkupId(true);
        this.container.add(new Component[]{this.header});
        this.container.add(new Component[]{new AjaxLink<Void>("close"){
            private static final long serialVersionUID = 5538299138211283825L;

            public void onClick(AjaxRequestTarget target) {
                TogglePanel.this.toggle(target, false);
            }
        }.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = -9027652037484739586L;

            protected String findIndicatorId() {
                return "";
            }

            protected void onEvent(AjaxRequestTarget target) {
            }
        }})});
    }

    public TogglePanel<T> addInnerObject(Component ... childs) {
        this.container.addOrReplace(childs);
        return this;
    }

    protected void setHeader(AjaxRequestTarget target, String header) {
        this.header.setDefaultModelObject((Object)Optional.ofNullable(header).map(s -> StringUtils.abbreviate((String)s, (int)25)).orElse(""));
        target.add(new Component[]{this.header});
    }

    public void close(AjaxRequestTarget target) {
        this.toggle(target, false);
    }

    protected String getTargetKey(Serializable modelObject) {
        String key = modelObject == null ? new ResourceModel("actions", "").getObject() : (modelObject instanceof EntityTO ? ((EntityTO)modelObject).getKey() : (modelObject instanceof AnyWrapper ? ((AnyWrapper)modelObject).getInnerObject().getKey() : (modelObject instanceof Attr ? ((Attr)modelObject).getSchema() : (modelObject instanceof ConfParam ? ((ConfParam)modelObject).getSchema() : (modelObject instanceof StatusBean ? (StringUtils.isNotBlank((CharSequence)((StatusBean)modelObject).getResource()) ? ((StatusBean)modelObject).getResource() : ((StatusBean)modelObject).getKey()) : (modelObject instanceof PolicyRuleWrapper ? ((PolicyRuleWrapper)modelObject).getConf().getName() : (modelObject instanceof ReportletWrapper ? ((ReportletWrapper)modelObject).getConf().getName() : (modelObject instanceof JobTO ? (((JobTO)modelObject).getRefKey() == null ? ((JobTO)modelObject).getRefDesc() : ((JobTO)modelObject).getRefKey()) : (modelObject instanceof ToggleableTarget ? ((ToggleableTarget)modelObject).getKey() : (modelObject instanceof Domain ? ((Domain)modelObject).getKey() : new ResourceModel("actions", "").getObject()))))))))));
        return key;
    }

    protected void updateLabelKeyValue(Serializable modelObject) {
        this.header.add(new Behavior[]{new AttributeModifier(LABEL_DATA_VALUE, (Serializable)((Object)this.getTargetKey(modelObject)))});
    }

    public void toggle(AjaxRequestTarget target, Serializable modelObject, boolean toggle) {
        this.updateLabelKeyValue(modelObject);
        this.toggle(target, toggle);
    }

    public void toggle(AjaxRequestTarget target, boolean toggle) {
        String selector = String.format("$(\"div#%s\")", this.activeId);
        if (toggle) {
            if (this.status == Status.INACTIVE) {
                target.add(new Component[]{this.container});
                target.appendJavaScript((CharSequence)(selector + ".toggle(\"slow\");" + selector + ".attr(\"class\", \"" + ToggleMenuCSS.CLASS.value() + " " + ToggleMenuCSS.CLASS_ACTIVE.value() + "\");"));
                this.status = Status.ACTIVE;
            } else if (this.status == Status.ACTIVE) {
                target.appendJavaScript((CharSequence)(selector + ".not(':visible').toggle(\"slow\").removeClass(\"" + ToggleMenuCSS.CLASS_INACTIVE.value() + "\").addClass(\"" + ToggleMenuCSS.CLASS_ACTIVE.value() + "y\");"));
            }
        } else if (this.status == Status.ACTIVE) {
            target.appendJavaScript((CharSequence)(selector + ".toggle(\"slow\");" + selector + ".attr(\"class\", \"" + ToggleMenuCSS.CLASS.value() + " " + ToggleMenuCSS.CLASS_INACTIVE.value() + "\");"));
            this.status = Status.INACTIVE;
        }
    }

    private static enum ToggleMenuCSS {
        CLASS("toggle-menu"),
        CLASS_ACTIVE("active-toggle-menu"),
        CLASS_INACTIVE("active-toggle-menu");

        private final String value;

        private ToggleMenuCSS(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    private static enum Status {
        INACTIVE,
        ACTIVE;

    }
}

