/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.chartjs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.List;
import org.apache.syncope.client.console.chartjs.Chart;
import org.apache.syncope.client.console.chartjs.ChartJSBehavior;
import org.apache.syncope.client.console.chartjs.DataSetChart;
import org.apache.syncope.client.console.chartjs.SimpleChart;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartJSPanel
extends Panel {
    private static final long serialVersionUID = -3844680585650585253L;
    private static final Logger LOG = LoggerFactory.getLogger(ChartJSPanel.class);
    private static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    private final IModel<? extends Chart<?>> model;
    private final WebMarkupContainer container;

    public ChartJSPanel(String id, IModel<? extends Chart<?>> model) {
        super(id, model);
        this.model = model;
        this.container = new WebMarkupContainer("chart");
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.container});
        this.container.setOutputMarkupId(true);
        this.container.add(new Behavior[]{new ChartJSBehavior()});
    }

    public Chart<?> getChart() {
        return (Chart)this.model.getObject();
    }

    public String generateChart() {
        String dataString = null;
        String optionString = null;
        try {
            List data = this.model.getObject() instanceof SimpleChart ? ((SimpleChart)this.model.getObject()).getData() : ((DataSetChart)this.model.getObject()).getData();
            dataString = MAPPER.writeValueAsString(data);
            optionString = MAPPER.writeValueAsString(((Chart)this.model.getObject()).getOptions());
        }
        catch (JsonProcessingException e) {
            LOG.error("Unexpected error during JSON serialization", (Throwable)e);
        }
        return "var " + this.container.getMarkupId() + " = WicketCharts['" + this.container.getMarkupId() + "']." + ((Chart)this.model.getObject()).getClass().getSimpleName() + "(" + dataString + ", " + optionString + ");";
    }
}

