/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.HistoricActivityInstanceQueryImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.AbstractHistoryManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.runtime.ActivityInstance;
import org.flowable.entitylink.api.history.HistoricEntityLink;
import org.flowable.entitylink.api.history.HistoricEntityLinkService;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.entitylink.service.impl.persistence.entity.HistoricEntityLinkEntity;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskLogEntryBuilder;
import org.flowable.task.service.HistoricTaskService;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryManager
extends AbstractHistoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DefaultHistoryManager.class.getName());

    public DefaultHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public void recordProcessInstanceEnd(ExecutionEntity processInstance, String deleteReason, String activityId, Date endTime) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstance.getProcessDefinitionId()) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId())) != null) {
            historicProcessInstance.markEnded(deleteReason, endTime);
            historicProcessInstance.setEndActivityId(activityId);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance), this.processEngineConfiguration.getEngineCfgKey());
            }
        }
    }

    @Override
    public void recordProcessInstanceNameChange(ExecutionEntity processInstanceExecution, String newName) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstanceExecution.getProcessDefinitionId()) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceExecution.getId())) != null) {
            historicProcessInstance.setName(newName);
        }
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processInstance.getProcessDefinitionId())) {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoricProcessInstanceEntityManager().create(processInstance);
            this.getHistoricProcessInstanceEntityManager().insert(historicProcessInstance, false);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance), this.processEngineConfiguration.getEngineCfgKey());
            }
        }
    }

    @Override
    public void recordProcessInstanceDeleted(String processInstanceId, String processDefinitionId, String processTenantId) {
        if (this.getHistoryManager().isHistoryEnabled(processDefinitionId)) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
            this.getHistoricDetailEntityManager().deleteHistoricDetailsByProcessInstanceId(processInstanceId);
            this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().deleteHistoricVariableInstancesByProcessInstanceId(processInstanceId);
            this.getHistoricActivityInstanceEntityManager().deleteHistoricActivityInstancesByProcessInstanceId(processInstanceId);
            TaskHelper.deleteHistoricTaskInstancesByProcessInstanceId(processInstanceId);
            this.processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().deleteHistoricIdentityLinksByProcessInstanceId(processInstanceId);
            if (this.processEngineConfiguration.isEnableEntityLinks()) {
                this.processEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService().deleteHistoricEntityLinksByScopeIdAndScopeType(processInstanceId, "bpmn");
            }
            this.getCommentEntityManager().deleteCommentsByProcessInstanceId(processInstanceId);
            if (historicProcessInstance != null) {
                this.getHistoricProcessInstanceEntityManager().delete(historicProcessInstance, false);
            }
            List<HistoricProcessInstance> selectList = this.getHistoricProcessInstanceEntityManager().findHistoricProcessInstancesBySuperProcessInstanceId(processInstanceId);
            for (HistoricProcessInstance child : selectList) {
                this.recordProcessInstanceDeleted(child.getId(), processDefinitionId, child.getTenantId());
            }
        }
    }

    @Override
    public void recordDeleteHistoricProcessInstancesByProcessDefinitionId(String processDefinitionId) {
        if (this.getHistoryManager().isHistoryEnabled(processDefinitionId)) {
            List<String> historicProcessInstanceIds = this.getHistoricProcessInstanceEntityManager().findHistoricProcessInstanceIdsByProcessDefinitionId(processDefinitionId);
            for (String historicProcessInstanceId : historicProcessInstanceIds) {
                this.recordProcessInstanceDeleted(historicProcessInstanceId, processDefinitionId, null);
            }
        }
    }

    @Override
    public void recordActivityStart(ActivityInstance activityInstance) {
        if (activityInstance != null && this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId()) && activityInstance.getActivityId() != null) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = this.createNewHistoricActivityInstance(activityInstance);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstanceEntity), this.processEngineConfiguration.getEngineCfgKey());
            }
        }
    }

    @Override
    public void recordActivityEnd(ActivityInstance activityInstance) {
        if (activityInstance != null && this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId())) {
            HistoricActivityInstanceEntity historicActivityInstance = (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().findById(activityInstance.getId());
            if (historicActivityInstance != null) {
                historicActivityInstance.setDeleteReason(activityInstance.getDeleteReason());
                historicActivityInstance.setEndTime(activityInstance.getEndTime());
                historicActivityInstance.setDurationInMillis(activityInstance.getDurationInMillis());
                FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
                if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance), this.processEngineConfiguration.getEngineCfgKey());
                }
            } else {
                LOGGER.debug("Historic activity instance was not found.");
            }
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason, Date endTime) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, executionEntity.getProcessDefinitionId()) && (historicActivityInstance = this.findHistoricActivityInstance(executionEntity, true)) != null) {
            historicActivityInstance.markEnded(deleteReason, endTime);
            FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance), this.processEngineConfiguration.getEngineCfgKey());
            }
        }
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        String processDefinitionId = null;
        if (execution != null) {
            processDefinitionId = execution.getProcessDefinitionId();
        } else if (task != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            if (execution != null) {
                task.setExecutionId(execution.getId());
                task.setProcessInstanceId(execution.getProcessInstanceId());
                task.setProcessDefinitionId(execution.getProcessDefinitionId());
                if (execution.getTenantId() != null) {
                    task.setTenantId(execution.getTenantId());
                }
            }
            HistoricTaskInstanceEntity historicTaskInstance = this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().recordTaskCreated(task);
            historicTaskInstance.setLastUpdateTime(this.processEngineConfiguration.getClock().getCurrentTime());
            if (execution != null) {
                historicTaskInstance.setExecutionId(execution.getId());
            }
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, ExecutionEntity execution, String deleteReason, Date endTime) {
        HistoricTaskInstanceEntity historicTaskInstance;
        String processDefinitionId = null;
        if (execution != null) {
            processDefinitionId = execution.getProcessDefinitionId();
        } else if (task != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId) && (historicTaskInstance = this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().recordTaskEnd(task, deleteReason, endTime)) != null) {
            historicTaskInstance.setLastUpdateTime(endTime);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity, String activityInstanceId, Date changeTime) {
        boolean assigneeChanged = false;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, taskEntity.getProcessDefinitionId())) {
            HistoricTaskInstanceEntity historicTaskInstance;
            HistoricTaskService historicTaskService = this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
            HistoricTaskInstanceEntity originalHistoricTaskInstanceEntity = historicTaskService.getHistoricTask(taskEntity.getId());
            String originalAssignee = null;
            if (originalHistoricTaskInstanceEntity != null) {
                originalAssignee = originalHistoricTaskInstanceEntity.getAssignee();
            }
            if ((historicTaskInstance = historicTaskService.recordTaskInfoChange(taskEntity, changeTime, (AbstractEngineConfiguration)this.processEngineConfiguration)) != null && !Objects.equals(originalAssignee, taskEntity.getAssignee())) {
                assigneeChanged = true;
            }
        }
        if (assigneeChanged && this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, taskEntity.getProcessDefinitionId()) && taskEntity.getExecutionId() != null) {
            HistoricActivityInstanceEntity historicActivityInstance;
            if (activityInstanceId != null) {
                historicActivityInstance = (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().findById(activityInstanceId);
            } else {
                ExecutionEntity executionEntity = (ExecutionEntity)this.getExecutionEntityManager().findById(taskEntity.getExecutionId());
                historicActivityInstance = this.findHistoricActivityInstance(executionEntity, true);
            }
            if (historicActivityInstance != null) {
                historicActivityInstance.setAssignee(taskEntity.getAssignee());
            }
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable, Date createTime) {
        String processDefinitionId = null;
        if (this.isEnableProcessDefinitionHistoryLevel() && variable.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(variable.getProcessInstanceId());
            processDefinitionId = processInstanceExecution.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().createAndInsert(variable, createTime);
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId, String activityInstanceId, Date createTime) {
        String processDefinitionId = this.getProcessDefinitionId(variable, sourceActivityExecution);
        if (this.isHistoryLevelAtLeast(HistoryLevel.FULL, processDefinitionId)) {
            HistoricActivityInstanceEntity historicActivityInstance;
            HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = this.getHistoricDetailEntityManager().copyAndInsertHistoricDetailVariableInstanceUpdateEntity(variable, createTime);
            if (StringUtils.isNotEmpty((CharSequence)activityInstanceId)) {
                historicVariableUpdate.setActivityInstanceId(activityInstanceId);
            } else if (useActivityId && sourceActivityExecution != null && (historicActivityInstance = this.findHistoricActivityInstance(sourceActivityExecution, false)) != null) {
                historicVariableUpdate.setActivityInstanceId(historicActivityInstance.getId());
            }
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variableInstanceEntity, Date updateTime) {
        String processDefinitionId = null;
        if (this.isEnableProcessDefinitionHistoryLevel() && variableInstanceEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(variableInstanceEntity.getProcessInstanceId());
            processDefinitionId = processInstanceExecution.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().recordVariableUpdate(variableInstanceEntity, updateTime);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variableInstanceEntity) {
        String processDefinitionId = null;
        if (this.isEnableProcessDefinitionHistoryLevel() && variableInstanceEntity.getProcessInstanceId() != null) {
            ExecutionEntity processInstanceExecution = (ExecutionEntity)this.processEngineConfiguration.getExecutionEntityManager().findById(variableInstanceEntity.getProcessInstanceId());
            processDefinitionId = processInstanceExecution.getProcessDefinitionId();
        }
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, processDefinitionId)) {
            this.processEngineConfiguration.getVariableServiceConfiguration().getHistoricVariableService().recordVariableRemoved(variableInstanceEntity);
        }
    }

    @Override
    public void recordFormPropertiesSubmitted(ExecutionEntity processInstance, Map<String, String> properties, String taskId, Date createTime) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processInstance.getProcessDefinitionId())) {
            for (String propertyId : properties.keySet()) {
                String propertyValue = properties.get(propertyId);
                this.getHistoricDetailEntityManager().insertHistoricFormPropertyEntity(processInstance, propertyId, propertyValue, taskId, createTime);
            }
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        String processDefinitionId = this.getProcessDefinitionId(identityLink);
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId) && (identityLink.getProcessInstanceId() != null || identityLink.getTaskId() != null)) {
            HistoricIdentityLinkService historicIdentityLinkService = this.processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService();
            HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
            historicIdentityLinkEntity.setId(identityLink.getId());
            historicIdentityLinkEntity.setGroupId(identityLink.getGroupId());
            historicIdentityLinkEntity.setProcessInstanceId(identityLink.getProcessInstanceId());
            historicIdentityLinkEntity.setTaskId(identityLink.getTaskId());
            historicIdentityLinkEntity.setType(identityLink.getType());
            historicIdentityLinkEntity.setUserId(identityLink.getUserId());
            historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(IdentityLinkEntity identityLink) {
        String processDefinitionId = this.getProcessDefinitionId(identityLink);
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            this.processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService().deleteHistoricIdentityLink(identityLink.getId());
        }
    }

    @Override
    public void recordEntityLinkCreated(EntityLinkEntity entityLink) {
        String processDefinitionId = this.getProcessDefinitionId(entityLink);
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            HistoricEntityLinkService historicEntityLinkService = this.processEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService();
            HistoricEntityLinkEntity historicEntityLinkEntity = (HistoricEntityLinkEntity)historicEntityLinkService.createHistoricEntityLink();
            historicEntityLinkEntity.setId(entityLink.getId());
            historicEntityLinkEntity.setLinkType(entityLink.getLinkType());
            historicEntityLinkEntity.setCreateTime(entityLink.getCreateTime());
            historicEntityLinkEntity.setScopeId(entityLink.getScopeId());
            historicEntityLinkEntity.setSubScopeId(entityLink.getSubScopeId());
            historicEntityLinkEntity.setScopeType(entityLink.getScopeType());
            historicEntityLinkEntity.setScopeDefinitionId(entityLink.getScopeDefinitionId());
            historicEntityLinkEntity.setParentElementId(entityLink.getParentElementId());
            historicEntityLinkEntity.setReferenceScopeId(entityLink.getReferenceScopeId());
            historicEntityLinkEntity.setReferenceScopeType(entityLink.getReferenceScopeType());
            historicEntityLinkEntity.setReferenceScopeDefinitionId(entityLink.getReferenceScopeDefinitionId());
            historicEntityLinkEntity.setRootScopeId(entityLink.getRootScopeId());
            historicEntityLinkEntity.setRootScopeType(entityLink.getRootScopeType());
            historicEntityLinkEntity.setHierarchyType(entityLink.getHierarchyType());
            historicEntityLinkService.insertHistoricEntityLink((HistoricEntityLink)historicEntityLinkEntity, false);
        }
    }

    @Override
    public void recordEntityLinkDeleted(EntityLinkEntity entityLink) {
        String processDefinitionId = this.getProcessDefinitionId(entityLink);
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT, processDefinitionId)) {
            this.processEngineConfiguration.getEntityLinkServiceConfiguration().getHistoricEntityLinkService().deleteHistoricEntityLink(entityLink.getId());
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (processInstance != null && this.isHistoryEnabled(processInstance.getProcessDefinitionId()) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId())) != null) {
            historicProcessInstance.setBusinessKey(processInstance.getProcessInstanceBusinessKey());
            this.getHistoricProcessInstanceEntityManager().update(historicProcessInstance, false);
        }
    }

    @Override
    public void updateProcessBusinessStatusInHistory(ExecutionEntity processInstance) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (processInstance != null && this.isHistoryEnabled(processInstance.getProcessDefinitionId()) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId())) != null) {
            historicProcessInstance.setBusinessStatus(processInstance.getProcessInstanceBusinessStatus());
            this.getHistoricProcessInstanceEntityManager().update(historicProcessInstance, false);
        }
    }

    @Override
    public void updateProcessDefinitionIdInHistory(ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance) {
        if (this.isHistoryEnabled(processDefinitionEntity.getId())) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId());
            historicProcessInstance.setProcessDefinitionId(processDefinitionEntity.getId());
            this.getHistoricProcessInstanceEntityManager().update(historicProcessInstance);
            HistoricTaskService historicTaskService = this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService();
            HistoricTaskInstanceQueryImpl taskQuery = new HistoricTaskInstanceQueryImpl();
            taskQuery.processInstanceId(processInstance.getId());
            List historicTasks = historicTaskService.findHistoricTaskInstancesByQueryCriteria(taskQuery);
            if (historicTasks != null) {
                for (HistoricTaskInstance historicTaskInstance : historicTasks) {
                    HistoricTaskInstanceEntity taskEntity = (HistoricTaskInstanceEntity)historicTaskInstance;
                    taskEntity.setProcessDefinitionId(processDefinitionEntity.getId());
                    historicTaskService.updateHistoricTask(taskEntity, true);
                }
            }
            HistoricActivityInstanceQueryImpl historicActivityQuery = new HistoricActivityInstanceQueryImpl();
            historicActivityQuery.processInstanceId(processInstance.getId());
            List<HistoricActivityInstance> historicActivities = this.getHistoricActivityInstanceEntityManager().findHistoricActivityInstancesByQueryCriteria(historicActivityQuery);
            if (historicActivities != null) {
                for (HistoricActivityInstance historicActivityInstance : historicActivities) {
                    HistoricActivityInstanceEntity activityEntity = (HistoricActivityInstanceEntity)historicActivityInstance;
                    activityEntity.setProcessDefinitionId(processDefinitionEntity.getId());
                    this.getHistoricActivityInstanceEntityManager().update(activityEntity);
                }
            }
        }
    }

    @Override
    public void updateHistoricActivityInstance(ActivityInstance activityInstance) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId()) && activityInstance.getExecutionId() != null && (historicActivityInstance = (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().findById(activityInstance.getId())) != null) {
            historicActivityInstance.setTaskId(activityInstance.getTaskId());
            historicActivityInstance.setAssignee(activityInstance.getAssignee());
            historicActivityInstance.setCalledProcessInstanceId(activityInstance.getCalledProcessInstanceId());
        }
    }

    @Override
    public void recordHistoricUserTaskLogEntry(HistoricTaskLogEntryBuilder taskLogEntryBuilder) {
        this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().createHistoricTaskLogEntry(taskLogEntryBuilder);
    }

    @Override
    public void deleteHistoryUserTaskLog(long logNumber) {
        this.processEngineConfiguration.getTaskServiceConfiguration().getHistoricTaskService().deleteHistoricTaskLogEntry(logNumber);
    }

    @Override
    public void createHistoricActivityInstance(ActivityInstance activityInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY, activityInstance.getProcessDefinitionId())) {
            this.createNewHistoricActivityInstance(activityInstance);
        }
    }

    protected HistoricActivityInstanceEntity createNewHistoricActivityInstance(ActivityInstance activityInstance) {
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.getHistoricActivityInstanceEntityManager().create(activityInstance);
        this.getHistoricActivityInstanceEntityManager().insert(historicActivityInstanceEntity);
        return historicActivityInstanceEntity;
    }
}

