/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.LoggingUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.support.SAML2MetadataSupport;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.xmlsec.signature.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlRegisteredServiceServiceProviderMetadataFacade {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlRegisteredServiceServiceProviderMetadataFacade.class);
    private final SPSSODescriptor ssoDescriptor;
    private final EntityDescriptor entityDescriptor;
    private final MetadataResolver metadataResolver;

    public static Optional<SamlRegisteredServiceServiceProviderMetadataFacade> get(SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredService registeredService, String entityID) {
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID), new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME)});
        return SamlRegisteredServiceServiceProviderMetadataFacade.get(resolver, registeredService, entityID, criteria);
    }

    public static Optional<SamlRegisteredServiceServiceProviderMetadataFacade> get(SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredService registeredService, RequestAbstractType request) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get(resolver, registeredService, SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)request));
    }

    private static Optional<SamlRegisteredServiceServiceProviderMetadataFacade> get(SamlRegisteredServiceCachingMetadataResolver resolver, SamlRegisteredService registeredService, String entityID, CriteriaSet criterions) {
        try {
            boolean expired;
            LOGGER.trace("Adapting SAML metadata for CAS service [{}] issued by [{}]", (Object)registeredService.getName(), (Object)entityID);
            criterions.add((Object)new EntityIdCriterion(entityID), true);
            LOGGER.debug("Locating metadata for entityID [{}] by attempting to run through the metadata chain...", (Object)entityID);
            MetadataResolver chainingMetadataResolver = resolver.resolve(registeredService, criterions);
            LOGGER.debug("Resolved metadata chain from [{}] using [{}]. Filtering the chain by entity ID [{}]", new Object[]{registeredService.getMetadataLocation(), chainingMetadataResolver.getId(), entityID});
            EntityDescriptor entityDescriptor = (EntityDescriptor)chainingMetadataResolver.resolveSingle((Object)criterions);
            if (entityDescriptor == null) {
                LOGGER.warn("Cannot find entity [{}] in metadata provider for criteria [{}]", (Object)entityID, (Object)criterions);
                return Optional.empty();
            }
            LOGGER.trace("Located entity descriptor in metadata for [{}]", (Object)entityID);
            if (entityDescriptor.getValidUntil() != null && (expired = entityDescriptor.getValidUntil().isBefore(ZonedDateTime.now(ZoneOffset.UTC).toInstant()))) {
                LOGGER.warn("Entity descriptor in the metadata has expired at [{}]", (Object)entityDescriptor.getValidUntil());
                return Optional.empty();
            }
            return SamlRegisteredServiceServiceProviderMetadataFacade.getServiceProviderSsoDescriptor(entityID, chainingMetadataResolver, entityDescriptor);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }
    }

    private static Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getServiceProviderSsoDescriptor(String entityID, MetadataResolver chainingMetadataResolver, EntityDescriptor entityDescriptor) {
        SPSSODescriptor ssoDescriptor = entityDescriptor.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (ssoDescriptor != null) {
            ZonedDateTime validUntil;
            boolean expired;
            LOGGER.debug("Located SP SSODescriptor in metadata for [{}]. Metadata is valid until [{}]", (Object)entityID, ObjectUtils.defaultIfNull((Object)ssoDescriptor.getValidUntil(), (Object)"forever"));
            if (ssoDescriptor.getValidUntil() != null && (expired = (validUntil = DateTimeUtils.zonedDateTimeOf((Instant)ssoDescriptor.getValidUntil())).isBefore(ZonedDateTime.now(ZoneOffset.UTC)))) {
                LOGGER.warn("SP SSODescriptor in the metadata has expired at [{}]", (Object)ssoDescriptor.getValidUntil());
                return Optional.empty();
            }
            return Optional.of(new SamlRegisteredServiceServiceProviderMetadataFacade(ssoDescriptor, entityDescriptor, chainingMetadataResolver));
        }
        LOGGER.warn("Could not locate SP SSODescriptor in the metadata for [{}]", (Object)entityID);
        return Optional.empty();
    }

    public ZonedDateTime getValidUntil() {
        return DateTimeUtils.zonedDateTimeOf((Instant)this.ssoDescriptor.getValidUntil());
    }

    public Organization getOrganization() {
        return this.ssoDescriptor.getOrganization();
    }

    public Signature getSignature() {
        return this.ssoDescriptor.getSignature();
    }

    public List<ContactPerson> getContactPersons() {
        return this.ssoDescriptor.getContactPersons();
    }

    public Duration getCacheDuration() {
        return this.ssoDescriptor.getCacheDuration();
    }

    public List<KeyDescriptor> getKeyDescriptors() {
        return this.ssoDescriptor.getKeyDescriptors();
    }

    public Extensions getExtensions() {
        return this.ssoDescriptor.getExtensions();
    }

    public List<String> getSupportedProtocols() {
        return this.ssoDescriptor.getSupportedProtocols();
    }

    public boolean isWantAssertionsSigned() {
        return this.ssoDescriptor.getWantAssertionsSigned();
    }

    public boolean isAuthnRequestsSigned() {
        return this.ssoDescriptor.isAuthnRequestsSigned();
    }

    public boolean isSupportedProtocol(String protocol) {
        return this.ssoDescriptor.isSupportedProtocol(protocol);
    }

    public String getEntityId() {
        return this.entityDescriptor.getEntityID();
    }

    public List<String> getSupportedNameIdFormats() {
        ArrayList<String> nameIdFormats = new ArrayList<String>();
        List children = this.ssoDescriptor.getOrderedChildren();
        if (children != null) {
            nameIdFormats.addAll(children.stream().filter(NameIDFormat.class::isInstance).map(child -> ((NameIDFormat)child).getURI()).collect(Collectors.toList()));
        }
        return nameIdFormats;
    }

    public List<SingleLogoutService> getSingleLogoutServices() {
        return this.ssoDescriptor.getEndpoints(SingleLogoutService.DEFAULT_ELEMENT_NAME);
    }

    public SingleLogoutService getSingleLogoutService() {
        return this.getSingleLogoutServices().get(0);
    }

    public SingleLogoutService getSingleLogoutService(String binding) {
        return this.getSingleLogoutServices().stream().filter(acs -> acs.getBinding().equalsIgnoreCase(binding)).findFirst().orElse(null);
    }

    public AssertionConsumerService getAssertionConsumerService(String binding) {
        List acsList = this.getAssertionConsumerServices().stream().filter(acs -> acs.getBinding().equalsIgnoreCase(binding)).collect(Collectors.toList());
        return (AssertionConsumerService)SAML2MetadataSupport.getDefaultIndexedEndpoint(acsList);
    }

    public List<String> getAssertionConsumerServiceLocations() {
        return this.getAssertionConsumerServices().stream().map(acs -> (String)StringUtils.defaultIfBlank((CharSequence)acs.getResponseLocation(), (CharSequence)acs.getLocation())).collect(Collectors.toList());
    }

    public List<String> getAssertionConsumerServiceLocations(String binding) {
        return this.getAssertionConsumerServices().stream().filter(acs -> acs.getBinding().equalsIgnoreCase(binding)).map(acs -> (String)StringUtils.defaultIfBlank((CharSequence)acs.getResponseLocation(), (CharSequence)acs.getLocation())).collect(Collectors.toList());
    }

    public Optional<String> getAssertionConsumerServiceFor(String binding, Integer index) {
        return this.getAssertionConsumerServices().stream().filter(acs -> acs.getBinding().equalsIgnoreCase(binding) && index != null && index.equals(acs.getIndex())).map(acs -> (String)StringUtils.defaultIfBlank((CharSequence)acs.getResponseLocation(), (CharSequence)acs.getLocation())).findFirst();
    }

    public AssertionConsumerService getAssertionConsumerServiceForPaosBinding() {
        return this.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
    }

    public AssertionConsumerService getAssertionConsumerServiceForPostBinding() {
        return this.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
    }

    public AssertionConsumerService getAssertionConsumerServiceForArtifactBinding() {
        return this.getAssertionConsumerService("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");
    }

    public boolean containsAssertionConsumerServices() {
        return !this.getAssertionConsumerServices().isEmpty();
    }

    public int assertionConsumerServicesSize() {
        return this.getAssertionConsumerServices().size();
    }

    private List<AssertionConsumerService> getAssertionConsumerServices() {
        return this.ssoDescriptor.getEndpoints(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
    }

    @Generated
    public SamlRegisteredServiceServiceProviderMetadataFacade(SPSSODescriptor ssoDescriptor, EntityDescriptor entityDescriptor, MetadataResolver metadataResolver) {
        this.ssoDescriptor = ssoDescriptor;
        this.entityDescriptor = entityDescriptor;
        this.metadataResolver = metadataResolver;
    }

    @Generated
    public SPSSODescriptor getSsoDescriptor() {
        return this.ssoDescriptor;
    }

    @Generated
    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    @Generated
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }
}

