/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scimv11.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.scimv11.dto.SCIMAttribute;
import net.tirasa.connid.bundles.scimv11.dto.SCIMSchema;
import net.tirasa.connid.bundles.scimv11.service.SCIMv11Service;
import net.tirasa.connid.bundles.scimv11.utils.SCIMv11Attributes;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public class SCIMv11Utils {
    private static final Log LOG = Log.getLog(SCIMv11Utils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public static GuardedString createProtectedPassword(String password) {
        GuardedString guardedString = new GuardedString(password.toCharArray());
        return guardedString;
    }

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw ConnectorException.wrap((Throwable)ex);
    }

    public static boolean isEmptyObject(Object obj) {
        return obj == null || obj instanceof List && new ArrayList((List)obj).isEmpty() || obj instanceof String && StringUtil.isBlank((String)((String)String.class.cast(obj)));
    }

    public static String cleanAttributesToGet(Set<String> attributesToGet, String customAttributesJSON) {
        if (attributesToGet.isEmpty()) {
            return SCIMv11Attributes.defaultAttributesToGet();
        }
        SCIMSchema customAttributesObj = StringUtil.isBlank((String)customAttributesJSON) ? null : SCIMv11Service.extractSCIMSchemas(customAttributesJSON);
        String result = "";
        for (String attributeToGet : attributesToGet) {
            if (attributeToGet.contains("__") || attributeToGet.contains("meta.") || attributeToGet.contains("entitlements.") || attributeToGet.toLowerCase().contains("password")) continue;
            if (attributeToGet.contains("name.")) {
                result = result + "name".concat(",");
                continue;
            }
            if (attributeToGet.contains("addresses.")) {
                result = result + "addresses".concat(",");
                continue;
            }
            if (attributeToGet.contains("phoneNumbers.")) {
                result = result + "phoneNumbers".concat(",");
                continue;
            }
            if (attributeToGet.contains("ims.")) {
                result = result + "ims".concat(",");
                continue;
            }
            if (attributeToGet.contains("emails.")) {
                result = result + "emails".concat(",");
                continue;
            }
            if (attributeToGet.contains("roles.")) {
                result = result + "roles".concat(",");
                continue;
            }
            if (attributeToGet.contains("groups.")) {
                result = result + "groups".concat(",");
                continue;
            }
            if (attributeToGet.contains("photos.")) {
                result = result + "photos".concat(",");
                continue;
            }
            if (attributeToGet.contains("x509Certificates.")) {
                result = result + "x509Certificates".concat(",");
                continue;
            }
            if (customAttributesObj == null) {
                result = result + attributeToGet.concat(",");
                continue;
            }
            if (SCIMv11Utils.isCustomAttribute(customAttributesObj, attributeToGet)) continue;
            result = result + attributeToGet.concat(",");
        }
        if (customAttributesObj != null) {
            for (SCIMAttribute attribute : customAttributesObj.getAttributes()) {
                if (result.contains(attribute.getName() + ",")) continue;
                result = result + attribute.getName().concat(",");
            }
        }
        if (!result.contains("userName,")) {
            result = result + "userName".concat(",");
        }
        if (!result.contains("id,")) {
            result = result + "id".concat(",");
        }
        if (!result.contains("name,")) {
            result = result + "name".concat(",");
        }
        return StringUtil.isBlank((String)result) ? SCIMv11Attributes.defaultAttributesToGet() : result.substring(0, result.length() - 1);
    }

    private static boolean isCustomAttribute(SCIMSchema customAttributes, String attribute) {
        for (SCIMAttribute customAttribute : customAttributes.getAttributes()) {
            String externalAttributeName = customAttribute.getSchema().concat(".").concat(customAttribute.getName());
            if (!externalAttributeName.equals(attribute)) continue;
            return true;
        }
        return false;
    }
}

