/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.wicket.model.IModel;

public final class DateOps {
    public static final ZoneOffset DEFAULT_OFFSET = OffsetDateTime.now().getOffset();

    public static Date convert(OffsetDateTime date) {
        return Optional.ofNullable(date).map(v -> new Date(v.toInstant().toEpochMilli())).orElse(null);
    }

    public static OffsetDateTime convert(Date date) {
        return Optional.ofNullable(date).map(v -> v.toInstant().atOffset(DEFAULT_OFFSET)).orElse(null);
    }

    private DateOps() {
    }

    public static class WrappedDateModel
    implements IModel<Date>,
    Serializable {
        private static final long serialVersionUID = 31027882183172L;
        private final IModel<OffsetDateTime> wrapped;

        public WrappedDateModel(IModel<OffsetDateTime> wrapped) {
            this.wrapped = wrapped;
        }

        public Date getObject() {
            return DateOps.convert((OffsetDateTime)this.wrapped.getObject());
        }

        public void setObject(Date object) {
            this.wrapped.setObject((Object)DateOps.convert(object));
        }
    }

    public static class Format
    implements Serializable {
        private static final long serialVersionUID = 27103019852866L;
        private final FastDateFormat fdf;

        public Format(FastDateFormat fdf) {
            this.fdf = fdf;
        }

        public String format(Date date) {
            return Optional.ofNullable(date).map(arg_0 -> ((FastDateFormat)this.fdf).format(arg_0)).orElse("");
        }

        public String format(OffsetDateTime date) {
            return Optional.ofNullable(date).map(v -> this.fdf.format(DateOps.convert(date))).orElse("");
        }
    }
}

