/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.identityconnectors.common.ReflectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.serializer.SerializerUtil;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertyImpl;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConfigurationClass;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.operations.SPIOperation;

public class JavaClassProperties {
    private static final String MSG_CLASS = "Class ''{0}'' does not have a property ''{1}''.";
    private static final String MSG_PROPERTY = "For property ''{0}'' expected type ''{1}'' actual type ''{2}''.";
    private static final String MSG_SETTER = "Found setter ''{0}'' but not the corresponding getter.";
    protected static final String GROOVY_LANG_GROOVY_OBJECT = "groovy.lang.GroovyObject";

    public static ConfigurationPropertiesImpl createConfigurationProperties(Configuration config) {
        try {
            return JavaClassProperties.createConfigurationProperties2(config);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public static Configuration createBean(ConfigurationPropertiesImpl properties, Class<? extends Configuration> configClass) {
        try {
            return JavaClassProperties.createBean2(properties, configClass);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public static void mergeIntoBean(ConfigurationPropertiesImpl properties, Configuration config) {
        try {
            JavaClassProperties.mergeIntoBean2(properties, config);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static ConfigurationPropertiesImpl createConfigurationProperties2(Configuration defaultObject) throws Exception {
        Class<?> config = defaultObject.getClass();
        ConfigurationPropertiesImpl properties = new ConfigurationPropertiesImpl();
        ArrayList<ConfigurationPropertyImpl> temp = new ArrayList<ConfigurationPropertyImpl>();
        Map<String, PropertyDescriptor> descs = JavaClassProperties.getFilteredProperties(config);
        for (PropertyDescriptor desc : descs.values()) {
            Class<?> type;
            Method getter = desc.getReadMethod();
            Method setter = desc.getWriteMethod();
            String name = desc.getName();
            ConfigurationProperty options = JavaClassProperties.getPropertyOptions(getter, setter);
            int order = 0;
            String helpKey = name + ".help";
            String displayKey = name + ".display";
            String groupKey = name + ".group";
            boolean confidential = false;
            boolean required = false;
            if (options != null) {
                if (StringUtil.isNotBlank((String)options.helpMessageKey())) {
                    helpKey = options.helpMessageKey();
                }
                if (StringUtil.isNotBlank((String)options.displayMessageKey())) {
                    displayKey = options.displayMessageKey();
                }
                if (StringUtil.isNotBlank((String)options.groupMessageKey())) {
                    groupKey = options.groupMessageKey();
                }
                order = options.order();
                confidential = options.confidential();
                required = options.required();
            }
            if (!FrameworkUtil.isSupportedConfigurationType(type = desc instanceof IndexedPropertyDescriptor ? Array.newInstance(desc.getPropertyType(), 0).getClass() : desc.getPropertyType())) {
                String MSG = "Property type ''{0}'' is not supported.";
                throw new IllegalArgumentException(MessageFormat.format("Property type ''{0}'' is not supported.", type));
            }
            Object value = getter.invoke((Object)defaultObject, new Object[0]);
            ConfigurationPropertyImpl prop = new ConfigurationPropertyImpl();
            prop.setConfidential(confidential);
            prop.setDisplayMessageKey(displayKey);
            prop.setHelpMessageKey(helpKey);
            prop.setGroupMessageKey(groupKey);
            prop.setName(name);
            prop.setOrder(order);
            prop.setValue(value);
            prop.setType(type);
            prop.setRequired(required);
            prop.setOperations(options == null ? null : JavaClassProperties.translateOperations(options.operations()));
            temp.add(prop);
        }
        properties.setProperties(temp);
        return properties;
    }

    private static Set<Class<? extends APIOperation>> translateOperations(Class<? extends SPIOperation>[] ops) {
        HashSet<Class<? extends APIOperation>> set = new HashSet<Class<? extends APIOperation>>();
        for (Class<? extends SPIOperation> spi : ops) {
            set.addAll(FrameworkUtil.spi2apis(spi));
        }
        return set;
    }

    private static Configuration createBean2(ConfigurationPropertiesImpl properties, Class<? extends Configuration> configClass) throws Exception {
        Configuration rv = configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        rv.setConnectorMessages(properties.getParent().getConnectorInfo().getMessages());
        JavaClassProperties.mergeIntoBean2(properties, rv);
        return rv;
    }

    private static void mergeIntoBean2(ConfigurationPropertiesImpl properties, Configuration config) throws Exception {
        Class<?> configClass = config.getClass();
        Map<String, PropertyDescriptor> descriptors = JavaClassProperties.getFilteredProperties(configClass);
        for (ConfigurationPropertyImpl property : properties.getProperties()) {
            String name = property.getName();
            PropertyDescriptor desc = descriptors.get(name);
            if (desc == null) {
                throw new IllegalArgumentException(MessageFormat.format(MSG_CLASS, configClass.getName(), name));
            }
            Object value = property.getValue();
            value = SerializerUtil.cloneObject((Object)value);
            Method setter = desc.getWriteMethod();
            try {
                setter.invoke((Object)config, value);
            }
            catch (IllegalArgumentException ex) {
                if (value == null) {
                    throw ex;
                }
                Class<?> expected = setter.getParameterTypes()[0];
                Class<?> actual = value.getClass();
                throw new IllegalArgumentException(MessageFormat.format(MSG_PROPERTY, name, expected, actual));
            }
        }
    }

    private static Map<String, PropertyDescriptor> getFilteredProperties(Class<? extends Configuration> config) throws Exception {
        HashMap<String, PropertyDescriptor> rv = new HashMap<String, PropertyDescriptor>();
        BeanInfo info = Introspector.getBeanInfo(config);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        TreeSet<String> excludes = new TreeSet<String>();
        excludes.add("connectorMessages");
        for (Class c : ReflectionUtil.getAllInterfaces(config)) {
            if (!c.getName().equals(GROOVY_LANG_GROOVY_OBJECT)) continue;
            excludes.add("metaClass");
            break;
        }
        boolean filterUnsupported = false;
        ConfigurationClass options = config.getAnnotation(ConfigurationClass.class);
        if (null != options) {
            excludes.addAll(Arrays.asList(options.ignore()));
            filterUnsupported = options.skipUnsupported();
        }
        for (PropertyDescriptor descriptor : descriptors) {
            String propName = descriptor.getName();
            if (descriptor.getWriteMethod() == null || excludes.contains(propName) || filterUnsupported && descriptor.getPropertyType() != null && !FrameworkUtil.isSupportedConfigurationType(descriptor.getPropertyType())) continue;
            if (descriptor.getReadMethod() == null) {
                throw new IllegalArgumentException(MessageFormat.format(MSG_SETTER, propName));
            }
            rv.put(propName, descriptor);
        }
        return rv;
    }

    private static ConfigurationProperty getPropertyOptions(Method getter, Method setter) {
        ConfigurationProperty opts = setter.getAnnotation(ConfigurationProperty.class);
        if (opts == null) {
            opts = getter.getAnnotation(ConfigurationProperty.class);
        }
        return opts;
    }
}

