/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.notification;

import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyAbout;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.notification.RecipientsProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class DefaultNotificationManager
implements NotificationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(NotificationManager.class);
    protected final DerSchemaDAO derSchemaDAO;
    protected final VirSchemaDAO virSchemaDAO;
    protected final NotificationDAO notificationDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnySearchDAO anySearchDAO;
    protected final AnyMatchDAO anyMatchDAO;
    protected final TaskDAO taskDAO;
    protected final DerAttrHandler derAttrHandler;
    protected final VirAttrHandler virAttrHandler;
    protected final UserDataBinder userDataBinder;
    protected final GroupDataBinder groupDataBinder;
    protected final AnyObjectDataBinder anyObjectDataBinder;
    protected final ConfParamOps confParamOps;
    protected final EntityFactory entityFactory;
    protected final IntAttrNameParser intAttrNameParser;
    protected final SearchCondVisitor searchCondVisitor;
    protected Optional<RecipientsProvider> perContextRecipientsProvider = Optional.empty();

    public DefaultNotificationManager(DerSchemaDAO derSchemaDAO, VirSchemaDAO virSchemaDAO, NotificationDAO notificationDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AnyMatchDAO anyMatchDAO, TaskDAO taskDAO, DerAttrHandler derAttrHandler, VirAttrHandler virAttrHandler, UserDataBinder userDataBinder, GroupDataBinder groupDataBinder, AnyObjectDataBinder anyObjectDataBinder, ConfParamOps confParamOps, EntityFactory entityFactory, IntAttrNameParser intAttrNameParser, SearchCondVisitor searchCondVisitor) {
        this.derSchemaDAO = derSchemaDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.notificationDAO = notificationDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anySearchDAO = anySearchDAO;
        this.anyMatchDAO = anyMatchDAO;
        this.taskDAO = taskDAO;
        this.derAttrHandler = derAttrHandler;
        this.virAttrHandler = virAttrHandler;
        this.userDataBinder = userDataBinder;
        this.groupDataBinder = groupDataBinder;
        this.anyObjectDataBinder = anyObjectDataBinder;
        this.confParamOps = confParamOps;
        this.entityFactory = entityFactory;
        this.intAttrNameParser = intAttrNameParser;
        this.searchCondVisitor = searchCondVisitor;
    }

    @Transactional(readOnly=true)
    public long getMaxRetries() {
        return (Long)this.confParamOps.get("Master", "notification.maxRetries", (Object)0L, Long.class);
    }

    protected NotificationTask getNotificationTask(Notification notification, Any<?> any, Map<String, Object> jexlVars) {
        if (any != null) {
            this.virAttrHandler.getValues(any);
        }
        ArrayList<User> recipients = new ArrayList<User>();
        if (notification.getRecipientsFIQL() != null) {
            recipients.addAll(this.anySearchDAO.search(SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)notification.getRecipientsFIQL(), (String[])new String[0]), List.of(), AnyTypeKind.USER));
        }
        if (notification.isSelfAsRecipient() && any instanceof User) {
            recipients.add((User)any);
        }
        HashSet recipientEmails = new HashSet();
        ArrayList recipientTOs = new ArrayList(recipients.size());
        recipients.forEach(recipient -> {
            this.virAttrHandler.getValues((Any)recipient);
            String email = this.getRecipientEmail(notification.getRecipientAttrName(), (User)recipient);
            if (email == null) {
                LOG.warn("{} cannot be notified: {} not found", recipient, (Object)notification.getRecipientAttrName());
            } else {
                recipientEmails.add(email);
                recipientTOs.add(this.userDataBinder.getUserTO(recipient, true));
            }
        });
        if (notification.getStaticRecipients() != null) {
            recipientEmails.addAll(notification.getStaticRecipients());
        }
        if (notification.getRecipientsProvider() != null) {
            try {
                RecipientsProvider recipientsProvider = (RecipientsProvider)ImplementationManager.build((Implementation)notification.getRecipientsProvider(), () -> this.perContextRecipientsProvider.orElse(null), instance -> {
                    this.perContextRecipientsProvider = Optional.of(instance);
                });
                recipientEmails.addAll(recipientsProvider.provideRecipients(notification));
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)notification.getRecipientsProvider(), (Object)e);
            }
        }
        jexlVars.put("recipients", recipientTOs);
        jexlVars.put("syncopeConf", this.confParamOps.list("Master"));
        jexlVars.put("events", notification.getEvents());
        NotificationTask task = (NotificationTask)this.entityFactory.newEntity(NotificationTask.class);
        task.setNotification(notification);
        if (any != null) {
            task.setEntityKey(any.getKey());
            task.setAnyTypeKind(any.getType().getKind());
        }
        task.setTraceLevel(notification.getTraceLevel());
        task.getRecipients().addAll(recipientEmails);
        task.setSender(notification.getSender());
        task.setSubject(notification.getSubject());
        if (StringUtils.isNotBlank((CharSequence)notification.getTemplate().getTextTemplate())) {
            task.setTextBody(DefaultNotificationManager.evaluate(notification.getTemplate().getTextTemplate(), jexlVars));
        }
        if (StringUtils.isNotBlank((CharSequence)notification.getTemplate().getHTMLTemplate())) {
            task.setHtmlBody(DefaultNotificationManager.evaluate(notification.getTemplate().getHTMLTemplate(), jexlVars));
        }
        return task;
    }

    protected static String evaluate(String template, Map<String, Object> jexlVars) {
        StringWriter writer = new StringWriter();
        JexlUtils.newJxltEngine().createTemplate(template).evaluate((JexlContext)new MapContext(jexlVars), (Writer)writer);
        return writer.toString();
    }

    public boolean notificationsAvailable(AuditElements.EventCategoryType type, String category, String subcategory, String event) {
        String successEvent = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)type, (String)category, (String)subcategory, (String)event, (AuditElements.Result)AuditElements.Result.SUCCESS);
        String failureEvent = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)type, (String)category, (String)subcategory, (String)event, (AuditElements.Result)AuditElements.Result.FAILURE);
        return this.notificationDAO.findAll().stream().anyMatch(notification -> notification.isActive() && (notification.getEvents().contains(successEvent) || notification.getEvents().contains(failureEvent)));
    }

    public void createTasks(AfterHandlingEvent event) {
        this.createTasks(event.getWho(), event.getType(), event.getCategory(), event.getSubcategory(), event.getEvent(), event.getCondition(), event.getBefore(), event.getOutput(), event.getInput());
    }

    public List<NotificationTask> createTasks(String who, AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result condition, Object before, Object output, Object ... input) {
        String currentEvent = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)type, (String)category, (String)subcategory, (String)event, (AuditElements.Result)condition);
        Any any = null;
        if (before instanceof UserTO) {
            any = this.userDAO.find(((UserTO)before).getKey());
        } else if (output instanceof UserTO) {
            any = this.userDAO.find(((UserTO)output).getKey());
        } else if (output instanceof Pair && ((Pair)output).getRight() instanceof UserTO) {
            any = this.userDAO.find(((UserTO)((Pair)output).getRight()).getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof UserTO) {
            any = this.userDAO.find(((ProvisioningResult)output).getEntity().getKey());
        } else if (before instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(((AnyObjectTO)before).getKey());
        } else if (output instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(((AnyObjectTO)output).getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(((ProvisioningResult)output).getEntity().getKey());
        } else if (before instanceof GroupTO) {
            any = this.groupDAO.find(((GroupTO)before).getKey());
        } else if (output instanceof GroupTO) {
            any = this.groupDAO.find(((GroupTO)output).getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof GroupTO) {
            any = this.groupDAO.find(((ProvisioningResult)output).getEntity().getKey());
        }
        AnyType anyType = Optional.ofNullable(any).map(Any::getType).orElse(null);
        LOG.debug("Search notification for [{}]{}", (Object)anyType, (Object)any);
        ArrayList<NotificationTask> notifications = new ArrayList<NotificationTask>();
        for (Notification notification : this.notificationDAO.findAll()) {
            if (LOG.isDebugEnabled()) {
                notification.getAbouts().forEach(a -> LOG.debug("Notification about {} defined: {}", (Object)a.getAnyType(), (Object)a.get()));
            }
            if (notification.isActive()) {
                if (!notification.getEvents().contains(currentEvent)) {
                    LOG.debug("No events found about {}", (Object)any);
                    continue;
                }
                if (anyType != null && any != null && !notification.getAbout(anyType).isEmpty() && !this.anyMatchDAO.matches(any, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)((AnyAbout)notification.getAbout(anyType).get()).get(), (String[])new String[0]))) continue;
                LOG.debug("Creating notification task for event {} about {}", (Object)currentEvent, (Object)any);
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("who", who);
                model.put("type", type);
                model.put("category", category);
                model.put("subcategory", subcategory);
                model.put("event", event);
                model.put("condition", condition);
                model.put("before", before);
                model.put("output", output);
                model.put("input", input);
                if (any instanceof User) {
                    model.put("user", this.userDataBinder.getUserTO((User)any, true));
                } else if (any instanceof Group) {
                    model.put("group", this.groupDataBinder.getGroupTO((Group)any, true));
                } else if (any instanceof AnyObject) {
                    model.put("anyObject", this.anyObjectDataBinder.getAnyObjectTO((AnyObject)any, true));
                }
                NotificationTask notificationTask = this.getNotificationTask(notification, any, model);
                notificationTask = (NotificationTask)this.taskDAO.save((Task)notificationTask);
                notifications.add(notificationTask);
                continue;
            }
            LOG.debug("Notification {} is not active, task will not be created", (Object)notification.getKey());
        }
        return notifications;
    }

    protected String getRecipientEmail(String recipientAttrName, User user) {
        IntAttrName intAttrName;
        String email = null;
        try {
            intAttrName = this.intAttrNameParser.parse(recipientAttrName, AnyTypeKind.USER);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified as recipient, ignoring", (Object)recipientAttrName, (Object)e);
            return null;
        }
        if ("username".equals(intAttrName.getField())) {
            email = user.getUsername();
        } else if (intAttrName.getSchemaType() != null) {
            Group group;
            UMembership membership = null;
            if (intAttrName.getMembershipOfGroup() != null && (group = this.groupDAO.findByName(intAttrName.getMembershipOfGroup())) != null) {
                membership = user.getMembership(group.getKey()).orElse(null);
            }
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    Optional attr;
                    Optional optional = attr = membership == null ? user.getPlainAttr(recipientAttrName) : user.getPlainAttr(recipientAttrName, membership);
                    if (!attr.isPresent()) break;
                    email = ((UPlainAttr)attr.get()).getValuesAsStrings().isEmpty() ? null : (String)((UPlainAttr)attr.get()).getValuesAsStrings().get(0);
                    break;
                }
                case DERIVED: {
                    DerSchema schema = (DerSchema)this.derSchemaDAO.find(recipientAttrName);
                    if (schema == null) {
                        LOG.warn("Ignoring non existing {} {}", (Object)DerSchema.class.getSimpleName(), (Object)recipientAttrName);
                        break;
                    }
                    email = membership == null ? this.derAttrHandler.getValue((Any)user, schema) : this.derAttrHandler.getValue((Any)user, (Membership)membership, schema);
                    break;
                }
                case VIRTUAL: {
                    VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(recipientAttrName);
                    if (virSchema == null) {
                        LOG.warn("Ignoring non existing {} {}", (Object)VirSchema.class.getSimpleName(), (Object)recipientAttrName);
                        break;
                    }
                    List virAttrValues = membership == null ? this.virAttrHandler.getValues((Any)user, virSchema) : this.virAttrHandler.getValues((Any)user, (Membership)membership, virSchema);
                    email = virAttrValues.isEmpty() ? null : (String)virAttrValues.get(0);
                    break;
                }
            }
        }
        return email;
    }

    public TaskExec<NotificationTask> storeExec(TaskExec<NotificationTask> execution) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(TaskType.NOTIFICATION, ((NotificationTask)execution.getTask()).getKey());
        task.add(execution);
        task.setExecuted(true);
        this.taskDAO.save((Task)task);
        return execution;
    }

    public void setTaskExecuted(String taskKey, boolean executed) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(TaskType.NOTIFICATION, taskKey);
        task.setExecuted(executed);
        this.taskDAO.save((Task)task);
    }

    public long countExecutionsWithStatus(String taskKey, String status) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(TaskType.NOTIFICATION, taskKey);
        long count = 0L;
        for (TaskExec taskExec : task.getExecs()) {
            if (status == null) {
                if (taskExec.getStatus() != null) continue;
                ++count;
                continue;
            }
            if (!status.equals(taskExec.getStatus())) continue;
            ++count;
        }
        return count;
    }
}

