/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.job.JobDelegate;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.AbstractInterruptableJob;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskJob
extends AbstractInterruptableJob {
    private static final Logger LOG = LoggerFactory.getLogger(TaskJob.class);
    public static final String DRY_RUN_JOBDETAIL_KEY = "dryRun";
    public static final String DELEGATE_IMPLEMENTATION = "delegateImpl";
    @Autowired
    private DomainHolder domainHolder;
    private TaskType taskType;
    private String taskKey;
    private SchedTaskJobDelegate delegate;

    public void setTaskInfo(TaskType taskType, String taskKey) {
        this.taskType = taskType;
        this.taskKey = taskKey;
    }

    @Override
    public JobDelegate getDelegate() {
        return this.delegate;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            String domain = context.getMergedJobDataMap().getString("domain");
            if (this.domainHolder.getDomains().containsKey(domain)) {
                AuthContextUtils.callAsAdmin((String)domain, () -> {
                    try {
                        ImplementationDAO implementationDAO = (ImplementationDAO)ApplicationContextProvider.getApplicationContext().getBean(ImplementationDAO.class);
                        Implementation implementation = implementationDAO.find(context.getMergedJobDataMap().getString(DELEGATE_IMPLEMENTATION));
                        if (implementation == null) {
                            LOG.error("Could not find Implementation '{}', aborting", (Object)context.getMergedJobDataMap().getString(DELEGATE_IMPLEMENTATION));
                        } else {
                            this.delegate = (SchedTaskJobDelegate)ImplementationManager.build((Implementation)implementation);
                            this.delegate.execute(this.taskType, this.taskKey, context.getMergedJobDataMap().getBoolean(DRY_RUN_JOBDETAIL_KEY), context);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("While executing task {}", (Object)this.taskKey, (Object)e);
                        throw new RuntimeException(e);
                    }
                    return null;
                });
            } else {
                LOG.debug("Domain {} not found, skipping", (Object)domain);
            }
        }
        catch (RuntimeException e) {
            LOG.error("While executing task {}", (Object)this.taskKey, (Object)e);
            throw new JobExecutionException("While executing task " + this.taskKey, (Throwable)e);
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

