/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.Optional;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;

public class SyncopeSpringBeanJobFactory
extends SpringBeanJobFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeSpringBeanJobFactory.class);

    protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
        Object job = super.createJobInstance(bundle);
        if (bundle.getJobDetail().getJobDataMap() != null) {
            if (job instanceof ReportJob) {
                Optional.ofNullable(bundle.getJobDetail().getJobDataMap().getString("report")).ifPresent(((ReportJob)job)::setReportKey);
            } else if (job instanceof TaskJob) {
                TaskType taskType = (TaskType)bundle.getJobDetail().getJobDataMap().get((Object)"taskType");
                String taskKey = bundle.getJobDetail().getJobDataMap().getString("taskKey");
                if (taskType != null && taskKey != null) {
                    ((TaskJob)job).setTaskInfo(taskType, taskKey);
                }
            }
        }
        DefaultListableBeanFactory factory = ApplicationContextProvider.getBeanFactory();
        try {
            if (factory.containsSingleton(bundle.getJobDetail().getKey().getName())) {
                factory.destroySingleton(bundle.getJobDetail().getKey().getName());
            }
            factory.registerSingleton(bundle.getJobDetail().getKey().getName(), job);
        }
        catch (Exception e) {
            LOG.error("While attempting to replace job instance as singleton Spring bean", (Throwable)e);
        }
        return job;
    }
}

