/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.TaskExecDAO;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSchedTaskJobDelegate<T extends SchedTask>
implements SchedTaskJobDelegate {
    protected static final Logger LOG = LoggerFactory.getLogger(SchedTaskJobDelegate.class);
    @Autowired
    private SecurityProperties securityProperties;
    protected TaskType taskType;
    protected T task;
    @Autowired
    protected TaskExecDAO taskExecDAO;
    @Autowired
    protected TaskDAO taskDAO;
    @Autowired
    protected TaskUtilsFactory taskUtilsFactory;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    protected final AtomicReference<String> status = new AtomicReference();
    protected boolean interrupt;
    protected boolean interrupted;

    public String currentStatus() {
        return this.status.get();
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Transactional
    public void execute(TaskType taskType, String taskKey, boolean dryRun, JobExecutionContext context) throws JobExecutionException {
        AuditElements.Result result;
        this.taskType = taskType;
        this.task = (SchedTask)this.taskDAO.find(taskType, taskKey);
        if (this.task == null) {
            throw new JobExecutionException("Task " + taskKey + " not found");
        }
        if (!this.task.isActive()) {
            LOG.info("Task {} not active, aborting...", (Object)taskKey);
            return;
        }
        String executor = Optional.ofNullable(context.getMergedJobDataMap().getString("executor")).orElse(this.securityProperties.getAdminUser());
        TaskExec execution = this.taskUtilsFactory.getInstance(taskType).newTaskExec();
        execution.setStart(OffsetDateTime.now());
        execution.setTask(this.task);
        execution.setExecutor(executor);
        this.status.set("Initialization completed");
        try {
            execution.setMessage(this.doExecute(dryRun, executor, context));
            execution.setStatus(TaskJob.Status.SUCCESS.name());
            result = AuditElements.Result.SUCCESS;
        }
        catch (JobExecutionException e) {
            LOG.error("While executing task {}", (Object)taskKey, (Object)e);
            result = AuditElements.Result.FAILURE;
            execution.setMessage(ExceptionUtils2.getFullStackTrace((Throwable)e));
            execution.setStatus(TaskJob.Status.FAILURE.name());
        }
        execution.setEnd(OffsetDateTime.now());
        if (this.hasToBeRegistered(execution)) {
            this.register(execution);
        }
        this.task = (SchedTask)this.taskDAO.save(this.task);
        this.status.set("Done");
        this.notificationManager.createTasks(executor, AuditElements.EventCategoryType.TASK, this.getClass().getSimpleName(), null, this.getClass().getSimpleName(), result, this.task, (Object)execution, new Object[0]);
        this.auditManager.audit(executor, AuditElements.EventCategoryType.TASK, this.task.getClass().getSimpleName(), null, null, result, this.task, null, new Object[0]);
    }

    protected abstract String doExecute(boolean var1, String var2, JobExecutionContext var3) throws JobExecutionException;

    protected boolean hasToBeRegistered(TaskExec<?> execution) {
        return false;
    }

    protected void register(TaskExec<?> execution) {
        this.taskExecDAO.saveAndAdd(this.taskType, this.task.getKey(), execution);
    }
}

