/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data.wa;

import org.apache.syncope.common.lib.policy.AccessPolicyTO;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyConf;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.AuthPolicyConf;
import org.apache.syncope.common.lib.policy.AuthPolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf;
import org.apache.syncope.common.lib.policy.DefaultAuthPolicyConf;
import org.apache.syncope.common.lib.wa.WAClientApp;
import org.apache.syncope.core.persistence.api.dao.AttrRepoDAO;
import org.apache.syncope.core.persistence.api.dao.AuthModuleDAO;
import org.apache.syncope.core.persistence.api.entity.am.AttrRepo;
import org.apache.syncope.core.persistence.api.entity.am.AuthModule;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.provisioning.api.data.AuthModuleDataBinder;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.apache.syncope.core.provisioning.api.data.wa.WAClientAppDataBinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAClientAppDataBinderImpl
implements WAClientAppDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(WAClientAppDataBinder.class);
    protected final ClientAppDataBinder clientAppDataBinder;
    protected final PolicyDataBinder policyDataBinder;
    protected final AuthModuleDataBinder authModuleDataBinder;
    protected final AuthModuleDAO authModuleDAO;
    protected final AttrRepoDAO attrRepoDAO;

    public WAClientAppDataBinderImpl(ClientAppDataBinder clientAppDataBinder, PolicyDataBinder policyDataBinder, AuthModuleDataBinder authModuleDataBinder, AuthModuleDAO authModuleDAO, AttrRepoDAO attrRepoDAO) {
        this.clientAppDataBinder = clientAppDataBinder;
        this.policyDataBinder = policyDataBinder;
        this.authModuleDataBinder = authModuleDataBinder;
        this.authModuleDAO = authModuleDAO;
        this.attrRepoDAO = attrRepoDAO;
    }

    public WAClientApp getWAClientApp(ClientApp clientApp) {
        WAClientApp waClientApp = new WAClientApp();
        waClientApp.setClientAppTO(this.clientAppDataBinder.getClientAppTO(clientApp));
        try {
            AuthPolicyConf authPolicyConf = null;
            if (clientApp.getAuthPolicy() != null) {
                authPolicyConf = clientApp.getAuthPolicy().getConf();
                waClientApp.setAuthPolicy((AuthPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getAuthPolicy()));
            } else if (clientApp.getRealm() != null && clientApp.getRealm().getAuthPolicy() != null) {
                authPolicyConf = clientApp.getRealm().getAuthPolicy().getConf();
                waClientApp.setAuthPolicy((AuthPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getRealm().getAuthPolicy()));
            }
            if (authPolicyConf instanceof DefaultAuthPolicyConf) {
                ((DefaultAuthPolicyConf)authPolicyConf).getAuthModules().forEach(key -> {
                    AuthModule authModule = this.authModuleDAO.find(key);
                    if (authModule == null) {
                        LOG.warn("AuthModule " + authModule + " not found");
                    } else {
                        waClientApp.getAuthModules().add(this.authModuleDataBinder.getAuthModuleTO(authModule));
                        authModule.getItems().forEach(item -> waClientApp.getReleaseAttrs().put(item.getIntAttrName(), item.getExtAttrName()));
                    }
                });
            }
            if (clientApp.getAccessPolicy() != null) {
                waClientApp.setAccessPolicy((AccessPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getAccessPolicy()));
            } else if (clientApp.getRealm() != null && clientApp.getRealm().getAccessPolicy() != null) {
                waClientApp.setAccessPolicy((AccessPolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getRealm().getAccessPolicy()));
            }
            AttrReleasePolicyConf attrReleasePolicyConf = null;
            if (clientApp.getAttrReleasePolicy() != null) {
                attrReleasePolicyConf = clientApp.getAttrReleasePolicy().getConf();
                waClientApp.setAttrReleasePolicy((AttrReleasePolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getAttrReleasePolicy()));
            } else if (clientApp.getRealm() != null && clientApp.getRealm().getAttrReleasePolicy() != null) {
                attrReleasePolicyConf = clientApp.getRealm().getAttrReleasePolicy().getConf();
                waClientApp.setAttrReleasePolicy((AttrReleasePolicyTO)this.policyDataBinder.getPolicyTO((Policy)clientApp.getRealm().getAttrReleasePolicy()));
            }
            if (attrReleasePolicyConf instanceof DefaultAttrReleasePolicyConf && ((DefaultAttrReleasePolicyConf)attrReleasePolicyConf).getPrincipalAttrRepoConf() != null) {
                ((DefaultAttrReleasePolicyConf)attrReleasePolicyConf).getPrincipalAttrRepoConf().getAttrRepos().forEach(key -> {
                    AttrRepo attrRepo = this.attrRepoDAO.find(key);
                    if (attrRepo == null) {
                        LOG.warn("AttrRepo " + attrRepo + " not found");
                    } else {
                        attrRepo.getItems().forEach(item -> waClientApp.getReleaseAttrs().put(item.getIntAttrName(), item.getExtAttrName()));
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("While building the configuration from an application's policy ", (Throwable)e);
        }
        return waClientApp;
    }
}

