/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Optional;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.CASSPClientAppTO;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.common.lib.to.SAML2SPClientAppTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.am.OIDCRPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPClientApp;
import org.apache.syncope.core.persistence.api.entity.policy.AccessPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AttrReleasePolicy;
import org.apache.syncope.core.persistence.api.entity.policy.AuthPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;

public class ClientAppDataBinderImpl
implements ClientAppDataBinder {
    protected final PolicyDAO policyDAO;
    protected final RealmDAO realmDAO;
    protected final EntityFactory entityFactory;

    public ClientAppDataBinderImpl(PolicyDAO policyDAO, RealmDAO realmDAO, EntityFactory entityFactory) {
        this.policyDAO = policyDAO;
        this.realmDAO = realmDAO;
        this.entityFactory = entityFactory;
    }

    public <T extends ClientApp> T create(ClientAppTO clientAppTO) {
        if (clientAppTO instanceof SAML2SPClientAppTO) {
            return (T)this.doCreate((SAML2SPClientAppTO)clientAppTO);
        }
        if (clientAppTO instanceof OIDCRPClientAppTO) {
            return (T)this.doCreate((OIDCRPClientAppTO)clientAppTO);
        }
        if (clientAppTO instanceof CASSPClientAppTO) {
            return (T)this.doCreate((CASSPClientAppTO)clientAppTO);
        }
        throw new IllegalArgumentException("Unsupported client app: " + clientAppTO.getClass().getName());
    }

    public <T extends ClientApp> void update(T clientApp, ClientAppTO clientAppTO) {
        if (clientAppTO instanceof SAML2SPClientAppTO) {
            this.doUpdate((SAML2SPClientApp)clientApp, (SAML2SPClientAppTO)clientAppTO);
        } else if (clientAppTO instanceof OIDCRPClientAppTO) {
            this.doUpdate((OIDCRPClientApp)clientApp, (OIDCRPClientAppTO)clientAppTO);
        } else if (clientAppTO instanceof CASSPClientAppTO) {
            this.doUpdate((CASSPClientApp)clientApp, (CASSPClientAppTO)clientAppTO);
        } else {
            throw new IllegalArgumentException("Unsupported client app: " + clientAppTO.getClass().getName());
        }
    }

    public <T extends ClientAppTO> T getClientAppTO(ClientApp clientApp) {
        if (clientApp instanceof SAML2SPClientApp) {
            return (T)this.getSAMLClientAppTO((SAML2SPClientApp)clientApp);
        }
        if (clientApp instanceof OIDCRPClientApp) {
            return (T)this.getOIDCClientAppTO((OIDCRPClientApp)clientApp);
        }
        if (clientApp instanceof CASSPClientApp) {
            return (T)this.getCASClientAppTO((CASSPClientApp)clientApp);
        }
        throw new IllegalArgumentException("Unsupported client app: " + clientApp.getClass().getName());
    }

    protected SAML2SPClientApp doCreate(SAML2SPClientAppTO clientAppTO) {
        SAML2SPClientApp saml2sp = (SAML2SPClientApp)this.entityFactory.newEntity(SAML2SPClientApp.class);
        this.update(saml2sp, (ClientAppTO)clientAppTO);
        return saml2sp;
    }

    protected CASSPClientApp doCreate(CASSPClientAppTO clientAppTO) {
        CASSPClientApp saml2sp = (CASSPClientApp)this.entityFactory.newEntity(CASSPClientApp.class);
        this.update(saml2sp, (ClientAppTO)clientAppTO);
        return saml2sp;
    }

    protected void doUpdate(SAML2SPClientApp clientApp, SAML2SPClientAppTO clientAppTO) {
        this.copyToEntity((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientApp.setEntityId(clientAppTO.getEntityId());
        clientApp.setMetadataLocation(clientAppTO.getMetadataLocation());
        clientApp.setMetadataSignatureLocation(clientAppTO.getMetadataSignatureLocation());
        clientApp.setSignAssertions(clientAppTO.isSignAssertions());
        clientApp.setSignResponses(clientAppTO.isSignResponses());
        clientApp.setEncryptionOptional(clientAppTO.isEncryptionOptional());
        clientApp.setEncryptAssertions(clientAppTO.isEncryptAssertions());
        clientApp.setRequiredAuthenticationContextClass(clientAppTO.getRequiredAuthenticationContextClass());
        clientApp.setRequiredNameIdFormat(clientAppTO.getRequiredNameIdFormat());
        clientApp.setSkewAllowance(clientAppTO.getSkewAllowance());
        clientApp.setNameIdQualifier(clientAppTO.getNameIdQualifier());
        clientApp.getAssertionAudiences().clear();
        clientApp.getAssertionAudiences().addAll(clientAppTO.getAssertionAudiences());
        clientApp.setServiceProviderNameIdQualifier(clientAppTO.getServiceProviderNameIdQualifier());
        clientApp.getSigningSignatureAlgorithms().clear();
        clientApp.getSigningSignatureAlgorithms().addAll(clientAppTO.getSigningSignatureAlgorithms());
        clientApp.getSigningSignatureReferenceDigestMethods().clear();
        clientApp.getSigningSignatureReferenceDigestMethods().addAll(clientAppTO.getSigningSignatureReferenceDigestMethods());
        clientApp.getEncryptionKeyAlgorithms().clear();
        clientApp.getEncryptionKeyAlgorithms().addAll(clientAppTO.getEncryptionKeyAlgorithms());
        clientApp.getEncryptionDataAlgorithms().clear();
        clientApp.getEncryptionDataAlgorithms().addAll(clientAppTO.getEncryptionDataAlgorithms());
        clientApp.getSigningSignatureBlackListedAlgorithms().clear();
        clientApp.getSigningSignatureBlackListedAlgorithms().addAll(clientAppTO.getSigningSignatureBlackListedAlgorithms());
        clientApp.getEncryptionBlackListedAlgorithms().clear();
        clientApp.getEncryptionBlackListedAlgorithms().addAll(clientAppTO.getEncryptionBlackListedAlgorithms());
    }

    protected void copyToTO(ClientApp clientApp, ClientAppTO clientAppTO) {
        clientAppTO.setKey(clientApp.getKey());
        clientAppTO.setRealm((String)Optional.ofNullable(clientApp.getRealm()).map(Realm::getFullPath).orElse(null));
        clientAppTO.setName(clientApp.getName());
        clientAppTO.setDescription(clientApp.getDescription());
        clientAppTO.setClientAppId(clientApp.getClientAppId());
        clientAppTO.setTheme(clientApp.getTheme());
        clientAppTO.setAuthPolicy((String)Optional.ofNullable(clientApp.getAuthPolicy()).map(Entity::getKey).orElse(null));
        clientAppTO.setAccessPolicy((String)Optional.ofNullable(clientApp.getAccessPolicy()).map(Entity::getKey).orElse(null));
        clientAppTO.setAttrReleasePolicy((String)Optional.ofNullable(clientApp.getAttrReleasePolicy()).map(Entity::getKey).orElse(null));
        clientAppTO.getProperties().addAll(clientApp.getProperties());
    }

    protected SAML2SPClientAppTO getSAMLClientAppTO(SAML2SPClientApp clientApp) {
        SAML2SPClientAppTO clientAppTO = new SAML2SPClientAppTO();
        this.copyToTO((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientAppTO.setEntityId(clientApp.getEntityId());
        clientAppTO.setMetadataLocation(clientApp.getMetadataLocation());
        clientAppTO.setMetadataSignatureLocation(clientApp.getMetadataSignatureLocation());
        clientAppTO.setSignAssertions(clientApp.isSignAssertions());
        clientAppTO.setSignResponses(clientApp.isSignResponses());
        clientAppTO.setEncryptionOptional(clientApp.isEncryptionOptional());
        clientAppTO.setEncryptAssertions(clientApp.isEncryptAssertions());
        clientAppTO.setRequiredAuthenticationContextClass(clientApp.getRequiredAuthenticationContextClass());
        clientAppTO.setRequiredNameIdFormat(clientApp.getRequiredNameIdFormat());
        clientAppTO.setSkewAllowance(clientApp.getSkewAllowance());
        clientAppTO.setNameIdQualifier(clientApp.getNameIdQualifier());
        clientAppTO.getAssertionAudiences().addAll(clientApp.getAssertionAudiences());
        clientAppTO.setServiceProviderNameIdQualifier(clientApp.getServiceProviderNameIdQualifier());
        clientAppTO.getSigningSignatureAlgorithms().addAll(clientApp.getSigningSignatureAlgorithms());
        clientAppTO.getSigningSignatureReferenceDigestMethods().addAll(clientApp.getSigningSignatureReferenceDigestMethods());
        clientAppTO.getEncryptionKeyAlgorithms().addAll(clientApp.getEncryptionKeyAlgorithms());
        clientAppTO.getEncryptionDataAlgorithms().addAll(clientApp.getEncryptionDataAlgorithms());
        clientAppTO.getSigningSignatureBlackListedAlgorithms().addAll(clientApp.getSigningSignatureBlackListedAlgorithms());
        clientAppTO.getEncryptionBlackListedAlgorithms().addAll(clientApp.getEncryptionBlackListedAlgorithms());
        return clientAppTO;
    }

    protected OIDCRPClientApp doCreate(OIDCRPClientAppTO clientAppTO) {
        OIDCRPClientApp oidcrp = (OIDCRPClientApp)this.entityFactory.newEntity(OIDCRPClientApp.class);
        this.update(oidcrp, (ClientAppTO)clientAppTO);
        return oidcrp;
    }

    protected void doUpdate(OIDCRPClientApp clientApp, OIDCRPClientAppTO clientAppTO) {
        this.copyToEntity((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientApp.setClientSecret(clientAppTO.getClientSecret());
        clientApp.setClientId(clientAppTO.getClientId());
        clientApp.setSignIdToken(clientAppTO.isSignIdToken());
        clientApp.setJwtAccessToken(clientAppTO.isJwtAccessToken());
        clientApp.setBypassApprovalPrompt(clientAppTO.isBypassApprovalPrompt());
        clientApp.setSubjectType(clientAppTO.getSubjectType());
        clientApp.getRedirectUris().clear();
        clientApp.getRedirectUris().addAll(clientAppTO.getRedirectUris());
        clientApp.getSupportedGrantTypes().clear();
        clientApp.getSupportedGrantTypes().addAll(clientAppTO.getSupportedGrantTypes());
        clientApp.getSupportedResponseTypes().clear();
        clientApp.getSupportedResponseTypes().addAll(clientAppTO.getSupportedResponseTypes());
        clientApp.setLogoutUri(clientAppTO.getLogoutUri());
    }

    protected OIDCRPClientAppTO getOIDCClientAppTO(OIDCRPClientApp clientApp) {
        OIDCRPClientAppTO clientAppTO = new OIDCRPClientAppTO();
        this.copyToTO((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientAppTO.setClientId(clientApp.getClientId());
        clientAppTO.setClientSecret(clientApp.getClientSecret());
        clientAppTO.setSignIdToken(clientApp.isSignIdToken());
        clientAppTO.setSubjectType(clientApp.getSubjectType());
        clientAppTO.getRedirectUris().addAll(clientApp.getRedirectUris());
        clientAppTO.getSupportedGrantTypes().addAll(clientApp.getSupportedGrantTypes());
        clientAppTO.getSupportedResponseTypes().addAll(clientApp.getSupportedResponseTypes());
        clientAppTO.setLogoutUri(clientApp.getLogoutUri());
        clientAppTO.setJwtAccessToken(clientApp.isJwtAccessToken());
        clientAppTO.setBypassApprovalPrompt(clientApp.isBypassApprovalPrompt());
        return clientAppTO;
    }

    protected void doUpdate(CASSPClientApp clientApp, CASSPClientAppTO clientAppTO) {
        this.copyToEntity((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientApp.setServiceId(clientAppTO.getServiceId());
    }

    protected CASSPClientAppTO getCASClientAppTO(CASSPClientApp clientApp) {
        CASSPClientAppTO clientAppTO = new CASSPClientAppTO();
        this.copyToTO((ClientApp)clientApp, (ClientAppTO)clientAppTO);
        clientAppTO.setServiceId(clientApp.getServiceId());
        return clientAppTO;
    }

    protected void copyToEntity(ClientApp clientApp, ClientAppTO clientAppTO) {
        Policy policy;
        if (clientAppTO.getRealm() == null) {
            clientApp.setRealm(null);
        } else {
            clientApp.setRealm(this.realmDAO.findByFullPath(clientAppTO.getRealm()));
        }
        clientApp.setName(clientAppTO.getName());
        clientApp.setClientAppId(clientAppTO.getClientAppId());
        clientApp.setDescription(clientAppTO.getDescription());
        clientApp.setTheme(clientAppTO.getTheme());
        if (clientAppTO.getAuthPolicy() == null) {
            clientApp.setAuthPolicy(null);
        } else {
            policy = this.policyDAO.find(clientAppTO.getAuthPolicy());
            if (policy instanceof AuthPolicy) {
                clientApp.setAuthPolicy((AuthPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AuthPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (clientAppTO.getAccessPolicy() == null) {
            clientApp.setAccessPolicy(null);
        } else {
            policy = this.policyDAO.find(clientAppTO.getAccessPolicy());
            if (policy instanceof AccessPolicy) {
                clientApp.setAccessPolicy((AccessPolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AccessPolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        if (clientAppTO.getAttrReleasePolicy() == null) {
            clientApp.setAttrReleasePolicy(null);
        } else {
            policy = this.policyDAO.find(clientAppTO.getAttrReleasePolicy());
            if (policy instanceof AttrReleasePolicy) {
                clientApp.setAttrReleasePolicy((AttrReleasePolicy)policy);
            } else {
                SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidPolicy);
                sce.getElements().add("Expected " + AttrReleasePolicy.class.getSimpleName() + ", found " + policy.getClass().getSimpleName());
                throw sce;
            }
        }
        clientApp.setProperties(clientAppTO.getProperties());
    }
}

